/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.lookup;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import net.javacrumbs.springws.test.lookup.AbstractResourceLookup;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadRootBasedResourceLookup
extends AbstractResourceLookup {
    static final String DEFAULT_PAYLOAD_DELIMITER = "/";
    static final String DEFAULT_DISCRIMINATOR_DELIMITER = "-";
    static final String DEFAULT_PATH_SUFFIX = "response.xml";
    static final String DEFAULT_PATH_PREFIX = "mock-xml/";
    private Map<String, String[]> discriminators;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private String pathPrefix = "mock-xml/";
    private String pathSuffix = "response.xml";
    private String discriminatorDelimiter = "-";
    private String payloadDelimiter = "/";
    private boolean prependUri = false;

    @Override
    public Resource lookupResource(URI uri, WebServiceMessage message) throws IOException {
        String resourceName;
        Resource resource;
        QName payloadQName;
        try {
            payloadQName = PayloadRootUtils.getPayloadRootQName((Source)message.getPayloadSource(), (TransformerFactory)TRANSFORMER_FACTORY);
        }
        catch (TransformerException e) {
            this.logger.warn((Object)"Can not resolve payload.", (Throwable)e);
            return null;
        }
        catch (XMLStreamException e) {
            this.logger.warn((Object)"Can not resolve payload.", (Throwable)e);
            return null;
        }
        String payloadName = payloadQName.getLocalPart();
        String[] expressions = this.getDiscriminators(payloadName);
        Document document = this.getXmlUtil().loadDocument(message);
        int discriminatorsCount = expressions.length;
        do {
            resourceName = this.getResourceName(uri, payloadName, expressions, discriminatorsCount, document);
            this.logger.debug((Object)("Looking for resource " + resourceName));
        } while (((resource = this.getResourceLoader().getResource(resourceName)) == null || !resource.exists()) && --discriminatorsCount >= 0);
        if (resource != null && resource.exists()) {
            this.logger.debug((Object)("Found resource " + resource));
            return this.processResource(uri, message, resource);
        }
        return null;
    }

    private String[] getDiscriminators(String payloadName) {
        String[] result = this.discriminators.get(payloadName);
        return result != null ? result : new String[]{};
    }

    protected String getResourceName(URI uri, String payloadName, String[] expressions, int discriminatorsCount, Document document) {
        String uriHost = this.prependUri ? uri.getHost() + this.payloadDelimiter : "";
        return this.pathPrefix + uriHost + payloadName + this.payloadDelimiter + this.getDiscriminatorExpression(uri, expressions, discriminatorsCount, document) + this.pathSuffix;
    }

    protected String getDiscriminatorExpression(URI uri, String[] expressions, int discriminatorsCount, Document document) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < discriminatorsCount; ++i) {
            String expression = expressions[i];
            String evaluated = this.evaluateExpression(expression, uri, document);
            if (!StringUtils.hasText((String)evaluated)) continue;
            result.append(evaluated).append(this.discriminatorDelimiter);
        }
        return result.toString();
    }

    public Map<String, String[]> getDiscriminatorsMap() {
        return this.discriminators;
    }

    public void setDiscriminatorsMap(Map<String, String[]> discriminators) {
        this.discriminators = discriminators;
    }

    public void setDiscriminators(Map<String, String> discriminators) {
        HashMap<String, String[]> disc = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : discriminators.entrySet()) {
            disc.put(entry.getKey(), entry.getValue().split("\\s*;\\s*"));
        }
        this.discriminators = disc;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public void setPathSuffix(String pathSuffix) {
        this.pathSuffix = pathSuffix;
    }

    public String getDiscriminatorDelimiter() {
        return this.discriminatorDelimiter;
    }

    public void setDiscriminatorDelimiter(String discriminatorDelimiter) {
        this.discriminatorDelimiter = discriminatorDelimiter;
    }

    public String getPayloadDelimiter() {
        return this.payloadDelimiter;
    }

    public void setPayloadDelimiter(String payloadDelimiter) {
        this.payloadDelimiter = payloadDelimiter;
    }

    public boolean isPrependUri() {
        return this.prependUri;
    }

    public void setPrependUri(boolean prependUri) {
        this.prependUri = prependUri;
    }
}

