/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.simple;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.WsTestException;
import net.javacrumbs.springws.test.simple.LimitingRequestProcessor;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

public class LimitingRequestProcessorWrapper
implements RequestProcessor,
LimitingRequestProcessor {
    private final RequestProcessor wrappedRequestProcessor;
    private int numberOfProcessedRequests = 0;
    private int minNumberOfProcessedRequests = 1;
    private int maxNumberOfProcessedRequests = 1;
    private final String requestProcessorDescription;

    public LimitingRequestProcessorWrapper(RequestProcessor wrappedRequestProcessor, String requestProcessorDescription) {
        this.wrappedRequestProcessor = wrappedRequestProcessor;
        this.requestProcessorDescription = requestProcessorDescription;
    }

    public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
        ++this.numberOfProcessedRequests;
        if (this.numberOfProcessedRequests > this.maxNumberOfProcessedRequests) {
            return null;
        }
        return this.wrappedRequestProcessor.processRequest(uri, messageFactory, request);
    }

    public int getNumberOfProcessedRequests() {
        return this.numberOfProcessedRequests;
    }

    public void verify() throws WsTestException {
        if (this.numberOfProcessedRequests < this.minNumberOfProcessedRequests) {
            throw new WsTestException(this.requestProcessorDescription + ": has not been called enough times, expected at least " + this.minNumberOfProcessedRequests + " calls, has been " + this.numberOfProcessedRequests + ".");
        }
    }

    public RequestProcessor getWrappedRequestProcessor() {
        return this.wrappedRequestProcessor;
    }

    public int getMinNumberOfProcessedRequests() {
        return this.minNumberOfProcessedRequests;
    }

    public void setMinNumberOfProcessedRequests(int minNumberOfProcessedRequests) {
        this.minNumberOfProcessedRequests = minNumberOfProcessedRequests;
    }

    public int getMaxNumberOfProcessedRequests() {
        return this.maxNumberOfProcessedRequests;
    }

    public void setMaxNumberOfProcessedRequests(int maxNumberOfProcessedRequests) {
        this.maxNumberOfProcessedRequests = maxNumberOfProcessedRequests;
    }

    public void setNumberOfProcessedRequests(int numberOfProcessedRequests) {
        this.numberOfProcessedRequests = numberOfProcessedRequests;
    }

    String getRequestProcessorDescription() {
        return this.requestProcessorDescription;
    }
}

