/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.util;

import java.util.Collection;
import net.javacrumbs.springws.test.AbstractMockWebServiceMessageSender;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;

public class MockMessageSenderInjector
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Collection templates = beanFactory.getBeansOfType(WebServiceTemplate.class).values();
        if (templates.size() == 0) {
            throw new BeanCreationException("No WebServiceTemplate found in the servlet context.");
        }
        Collection mockSenders = beanFactory.getBeansOfType(AbstractMockWebServiceMessageSender.class).values();
        WebServiceMessageSender[] mockSenderArray = mockSenders.toArray(new WebServiceMessageSender[mockSenders.size()]);
        for (WebServiceTemplate template : templates) {
            template.setMessageSenders(mockSenderArray);
        }
    }
}

