/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.converter;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.AutoValueConverter;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.converter.ValueConverter;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Converter {
    private ValueConverter defaultConverter;
    private HashMap<String, ValueConverter> converterMap;
    public static final ValueConverter NUMBER = new ValueConverter(){

        @Override
        public Number convert(String input) throws ConverterException {
            try {
                return NumberUtils.createNumber((String)input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter EPOCH = new ValueConverter(){

        @Override
        public Date convert(String input) throws ConverterException {
            try {
                return new Date(Long.parseLong(input));
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter ISODATE = new ValueConverter(){

        public DateTime convert(String input) throws ConverterException {
            try {
                DateTimeFormatter parser = ISODateTimeFormat.dateOptionalTimeParser().withZoneUTC();
                return parser.parseDateTime(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter DATE = new ValueConverter(){

        public DateTime convert(String input) throws ConverterException {
            try {
                DateTimeFormatter parser = ISODateTimeFormat.dateOptionalTimeParser().withOffsetParsed();
                return parser.parseDateTime(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter BOOLEAN = new ValueConverter(){

        @Override
        public Boolean convert(String input) throws ConverterException {
            try {
                return Boolean.parseBoolean(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter STRING = new ValueConverter(){

        @Override
        public String convert(String input) throws ConverterException {
            try {
                return input;
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter REGEX_I = new ValueConverter(){

        @Override
        public Pattern convert(String input) throws ConverterException {
            try {
                return Pattern.compile(input, 66);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter REGEX = new ValueConverter(){

        @Override
        public Pattern convert(String input) throws ConverterException {
            try {
                return Pattern.compile(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final ValueConverter GLOB = new ValueConverter(){

        @Override
        public Object convert(String input) throws ConverterException {
            try {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    };
    public static final Map<String, ValueConverter> CONVERTERS = new HashMap<String, ValueConverter>();

    public Converter() {
        this(new AutoValueConverter(), CONVERTERS);
    }

    public Converter(ValueConverter defaultConverter) {
        this(defaultConverter, CONVERTERS);
    }

    public Converter(Map<String, ValueConverter> converterMap) {
        this(new AutoValueConverter(), converterMap);
    }

    public Converter(ValueConverter defaultConverter, Map<String, ValueConverter> converterMap) {
        this.defaultConverter = defaultConverter;
        this.converterMap = new HashMap<String, ValueConverter>(converterMap);
    }

    public Object convert(String input) throws ConverterException {
        ValueConverter converter = this.defaultConverter;
        int pos = input.indexOf(":");
        if (pos >= 0) {
            String value;
            String type = input.substring(0, pos);
            String string = value = input.length() > pos + 1 ? input.substring(pos + 1) : "";
            if (this.converterMap.containsKey(type)) {
                converter = this.converterMap.get(type);
                input = value;
            }
        }
        try {
            input = URLDecoder.decode(input.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ConverterException(e);
        }
        return converter.convert(input);
    }

    static {
        CONVERTERS.put("number", NUMBER);
        CONVERTERS.put("epoch", EPOCH);
        CONVERTERS.put("isodate", ISODATE);
        CONVERTERS.put("date", DATE);
        CONVERTERS.put("boolean", BOOLEAN);
        CONVERTERS.put("string", STRING);
        CONVERTERS.put("re", REGEX_I);
        CONVERTERS.put("RE", REGEX);
    }
}

