/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.FixedSeedMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.PropertyAttributes;
import net.jqwik.engine.PropertyAttributesDefaults;
import net.jqwik.engine.execution.GenerationInfo;

public class PropertyConfiguration {
    private final PropertyAttributes propertyAttributes;
    private final PropertyAttributesDefaults propertyAttributesDefaults;
    private final GenerationInfo previousFailureGeneration;
    private final String overriddenSeed;
    private final Integer overriddenTries;
    private final GenerationMode overriddenGenerationMode;

    public static PropertyConfiguration from(PropertyAttributes propertyAttributes, PropertyAttributesDefaults propertyAttributesDefaults, GenerationInfo generationInfo) {
        return new PropertyConfiguration(propertyAttributes, propertyAttributesDefaults, generationInfo, null, null, null);
    }

    public PropertyConfiguration(PropertyAttributes propertyAttributes, PropertyAttributesDefaults propertyAttributesDefaults, GenerationInfo previousFailureGeneration, String overriddenSeed, Integer overriddenTries, GenerationMode overriddenGenerationMode) {
        this.propertyAttributes = propertyAttributes;
        this.propertyAttributesDefaults = propertyAttributesDefaults;
        this.overriddenSeed = overriddenSeed;
        this.previousFailureGeneration = previousFailureGeneration;
        this.overriddenTries = overriddenTries;
        this.overriddenGenerationMode = overriddenGenerationMode;
    }

    public PropertyConfiguration withSeed(String changedSeed) {
        return new PropertyConfiguration(this.propertyAttributes, this.propertyAttributesDefaults, this.previousFailureGeneration, changedSeed, this.overriddenTries, this.overriddenGenerationMode);
    }

    public PropertyConfiguration withGenerationMode(GenerationMode changedGenerationMode) {
        return new PropertyConfiguration(this.propertyAttributes, this.propertyAttributesDefaults, this.previousFailureGeneration, this.overriddenSeed, this.overriddenTries, changedGenerationMode);
    }

    public PropertyConfiguration withTries(int changedTries) {
        return new PropertyConfiguration(this.propertyAttributes, this.propertyAttributesDefaults, this.previousFailureGeneration, this.overriddenSeed, changedTries, this.overriddenGenerationMode);
    }

    public PropertyAttributes getPropertyAttributes() {
        return this.propertyAttributes;
    }

    public int getTries() {
        if (this.overriddenTries != null) {
            return this.overriddenTries;
        }
        return this.propertyAttributes.tries().orElse(this.propertyAttributesDefaults.tries());
    }

    public String getSeed() {
        if (this.overriddenSeed != null) {
            return this.overriddenSeed;
        }
        return this.propertyAttributes.seed().orElse("");
    }

    public GenerationMode getGenerationMode() {
        if (this.overriddenGenerationMode != null) {
            return this.overriddenGenerationMode;
        }
        return this.propertyAttributes.generation().orElse(this.propertyAttributesDefaults.generation());
    }

    public GenerationInfo getPreviousFailureGeneration() {
        return this.previousFailureGeneration;
    }

    public String getStereotype() {
        return this.propertyAttributes.stereotype().orElse(this.propertyAttributesDefaults.stereotype());
    }

    public int getMaxDiscardRatio() {
        return this.propertyAttributes.maxDiscardRatio().orElse(this.propertyAttributesDefaults.maxDiscardRatio());
    }

    public ShrinkingMode getShrinkingMode() {
        return this.propertyAttributes.shrinking().orElse(this.propertyAttributesDefaults.shrinking());
    }

    public AfterFailureMode getAfterFailureMode() {
        return this.propertyAttributes.afterFailure().orElse(this.propertyAttributesDefaults.afterFailure());
    }

    public EdgeCasesMode getEdgeCasesMode() {
        return this.propertyAttributes.edgeCases().orElse(this.propertyAttributesDefaults.edgeCases());
    }

    public int boundedShrinkingSeconds() {
        return this.propertyAttributesDefaults.boundedShrinkingSeconds();
    }

    public FixedSeedMode getFixedSeedMode() {
        return this.propertyAttributes.whenFixedSeed().orElse(this.propertyAttributesDefaults.whenFixedSeed());
    }

    public boolean hasFixedSeed() {
        return !this.getSeed().equals("");
    }

    public boolean previousFailureMustBeHandled() {
        return this.previousRunFailed() && this.getAfterFailureMode() != AfterFailureMode.RANDOM_SEED;
    }

    private boolean previousRunFailed() {
        return this.previousFailureGeneration.randomSeed().isPresent();
    }

    public PropertyConfiguration withPreviousGenerationSeed() {
        return this.previousFailureGeneration.randomSeed().map(this::withSeed).orElse(this);
    }

    public PropertyConfiguration withFixedSeed() {
        return this.withSeed(this.getSeed());
    }

    public boolean seedHasNotChanged() {
        return this.getSeed().equals(this.getPreviousFailureGeneration().randomSeed().orElse(null));
    }
}

