/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.providers.ArbitraryProvider;

class CombinedDomainContext
implements DomainContext {
    private final List<ArbitraryProvider> providers = new ArrayList<ArbitraryProvider>();
    private final List<ArbitraryConfigurator> configurators = new ArrayList<ArbitraryConfigurator>();
    private final List<SampleReportingFormat> reportingFormats = new ArrayList<SampleReportingFormat>();

    CombinedDomainContext(Set<DomainContext> domainContexts) {
        for (DomainContext domainContext : domainContexts) {
            this.providers.addAll(domainContext.getArbitraryProviders());
            this.configurators.addAll(domainContext.getArbitraryConfigurators());
            this.reportingFormats.addAll(domainContext.getReportingFormats());
        }
        Collections.sort(this.configurators);
    }

    public Collection<ArbitraryProvider> getArbitraryProviders() {
        return this.providers;
    }

    public Collection<ArbitraryConfigurator> getArbitraryConfigurators() {
        return this.configurators;
    }

    public Collection<SampleReportingFormat> getReportingFormats() {
        return this.reportingFormats;
    }
}

