/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.Collection;
import java.util.function.Supplier;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.engine.properties.configurators.RegisteredArbitraryConfigurators;
import net.jqwik.engine.providers.RegisteredArbitraryProviders;

public class CurrentDomainContext {
    public static final DomainContext GLOBAL_DOMAIN_CONTEXT = new GlobalDomainContext();
    private static final ThreadLocal<DomainContext> currentContext = new ThreadLocal();

    public static DomainContext get() {
        if (currentContext.get() == null) {
            return GLOBAL_DOMAIN_CONTEXT;
        }
        return currentContext.get();
    }

    public static <T> T runWithContext(DomainContext context, Supplier<T> runnable) {
        currentContext.set(context);
        try {
            T t = runnable.get();
            return t;
        }
        finally {
            if (currentContext.get() == context) {
                currentContext.remove();
            }
        }
    }

    private static class GlobalDomainContext
    implements DomainContext {
        private GlobalDomainContext() {
        }

        public Collection<ArbitraryProvider> getArbitraryProviders() {
            return RegisteredArbitraryProviders.getProviders();
        }

        public Collection<ArbitraryConfigurator> getArbitraryConfigurators() {
            return RegisteredArbitraryConfigurators.getConfigurators();
        }
    }
}

