/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.lifecycle.CannotFindStoreException;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import org.junit.platform.engine.TestDescriptor;

public class StoreFacadeImpl
extends Store.StoreFacade {
    public <T> Store<T> create(Object identifier, Lifespan lifespan, Supplier<T> initialValueSupplier) {
        TestDescriptor scope = CurrentTestDescriptor.get();
        return StoreRepository.getCurrent().create(scope, identifier, lifespan, initialValueSupplier);
    }

    public <T> Store<T> get(Object identifier) {
        TestDescriptor retriever = CurrentTestDescriptor.get();
        Optional store = StoreRepository.getCurrent().get(retriever, identifier);
        return store.orElseThrow(() -> new CannotFindStoreException(identifier, retriever.getUniqueId().toString()));
    }

    public <T> Store<T> free(final Supplier<T> initialValueSupplier) {
        return new Store<T>(){
            T t;
            {
                this.t = initialValueSupplier.get();
            }

            public T get() {
                return this.t;
            }

            public Lifespan lifespan() {
                return Lifespan.RUN;
            }

            public void update(Function<T, T> updater) {
                this.t = updater.apply(this.t);
            }

            public void reset() {
                this.t = initialValueSupplier.get();
            }
        };
    }
}

