/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.DefaultArbitraries;

public class RegisteredArbitraryConfigurer {
    private final List<ArbitraryConfigurator> registeredConfigurators = new ArrayList<ArbitraryConfigurator>();

    public RegisteredArbitraryConfigurer(Collection<ArbitraryConfigurator> registeredConfigurators) {
        this.registeredConfigurators.addAll(registeredConfigurators);
        this.registeredConfigurators.addAll(DefaultArbitraries.getDefaultConfigurators());
        Collections.sort(this.registeredConfigurators);
    }

    public Arbitrary<?> configure(Arbitrary<?> createdArbitrary, TypeUsage targetType) {
        if (this.hasConfigurationAnnotation(targetType)) {
            for (ArbitraryConfigurator arbitraryConfigurator : this.registeredConfigurators) {
                if (createdArbitrary == null) break;
                createdArbitrary = SelfConfiguringArbitrary.configure(createdArbitrary, (ArbitraryConfigurator)arbitraryConfigurator, (TypeUsage)targetType);
            }
        }
        return createdArbitrary;
    }

    private boolean hasConfigurationAnnotation(TypeUsage targetType) {
        return targetType.getAnnotations().stream().anyMatch(annotation -> !annotation.annotationType().equals(ForAll.class));
    }
}

