/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultDoubleArbitrary
extends TypedCloneable
implements DoubleArbitrary {
    private static final double DEFAULT_MIN = -1.7976931348623157E308;
    private static final double DEFAULT_MAX = Double.MAX_VALUE;
    private DecimalGeneratingArbitrary generatingArbitrary;
    private final Set<Double> specials = new LinkedHashSet<Double>();

    public DefaultDoubleArbitrary() {
        this.generatingArbitrary = new DecimalGeneratingArbitrary(Range.of(this.toBigDecimal(-1.7976931348623157E308), this.toBigDecimal(Double.MAX_VALUE)));
    }

    public RandomGenerator<Double> generator(int genSize) {
        return this.arbitrary().generator(genSize);
    }

    public Optional<ExhaustiveGenerator<Double>> exhaustive(long maxNumberOfSamples) {
        return this.arbitrary().exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<Double> edgeCases(int maxEdgeCases) {
        return this.arbitrary().edgeCases(maxEdgeCases);
    }

    public Arbitrary<Double> edgeCases(Consumer<EdgeCases.Config<Double>> configurator) {
        MappedEdgeCasesConsumer<Double, BigDecimal> decimalConfigurator = new MappedEdgeCasesConsumer<Double, BigDecimal>(configurator, BigDecimal::doubleValue, BigDecimal::valueOf);
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary = (DecimalGeneratingArbitrary)this.generatingArbitrary.edgeCases(decimalConfigurator);
        return clone;
    }

    public DoubleArbitrary withDistribution(RandomDistribution distribution) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public DoubleArbitrary between(double min, boolean minIncluded, double max, boolean maxIncluded) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.range = Range.of(this.toBigDecimal(min), minIncluded, this.toBigDecimal(max), maxIncluded);
        return clone;
    }

    public DoubleArbitrary greaterOrEqual(double min) {
        return this.between(min, true, ((BigDecimal)this.generatingArbitrary.range.max).doubleValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public DoubleArbitrary greaterThan(double min) {
        return this.between(min, false, ((BigDecimal)this.generatingArbitrary.range.max).doubleValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public DoubleArbitrary lessOrEqual(double max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).doubleValue(), this.generatingArbitrary.range.minIncluded, max, true);
    }

    public DoubleArbitrary lessThan(double max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).doubleValue(), this.generatingArbitrary.range.minIncluded, max, false);
    }

    public DoubleArbitrary ofScale(int scale) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public DoubleArbitrary shrinkTowards(double target) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigDecimal.valueOf(target);
        return clone;
    }

    public DoubleArbitrary withSpecialValue(double special) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.specials.add(special);
        return clone;
    }

    public DoubleArbitrary withStandardSpecialValues() {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.specials.add(Double.NaN);
        clone.specials.add((Double)Double.MIN_VALUE);
        clone.specials.add((Double)Double.MIN_NORMAL);
        clone.specials.add(Double.POSITIVE_INFINITY);
        clone.specials.add(Double.NEGATIVE_INFINITY);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDoubleArbitrary that = (DefaultDoubleArbitrary)o;
        if (!this.generatingArbitrary.equals(that.generatingArbitrary)) {
            return false;
        }
        return this.specials.equals(that.specials);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.generatingArbitrary, this.specials);
    }

    private BigDecimal toBigDecimal(double value) {
        return new BigDecimal(Double.toString(value));
    }

    private Arbitrary<Double> arbitrary() {
        Arbitrary doubleArbitrary = this.generatingArbitrary.map(BigDecimal::doubleValue);
        if (this.specials.isEmpty()) {
            return doubleArbitrary;
        }
        Arbitrary specialsArbitrary = Arbitraries.of(this.specials).edgeCases(c -> c.add((Object[])this.specials.toArray(new Double[0])));
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)49, (Object)doubleArbitrary), Tuple.of((Object)1, (Object)specialsArbitrary)});
    }
}

