/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.MapArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultMapArbitrary<K, V>
extends ArbitraryDecorator<Map<K, V>>
implements MapArbitrary<K, V> {
    private final Arbitrary<K> keysArbitrary;
    private final Arbitrary<V> valuesArbitrary;
    private int minSize = 0;
    private Integer maxSize = null;
    private RandomDistribution sizeDistribution = null;
    private Set<FeatureExtractor<K>> keyUniquenessExtractors = new LinkedHashSet<FeatureExtractor<K>>();
    private Set<FeatureExtractor<V>> valueUniquenessExtractors = new LinkedHashSet<FeatureExtractor<V>>();

    public DefaultMapArbitrary(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        this.keysArbitrary = keysArbitrary;
        this.valuesArbitrary = valuesArbitrary;
    }

    public MapArbitrary<K, V> ofMinSize(int minSize) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.minSize = minSize;
        return clone;
    }

    public MapArbitrary<K, V> ofMaxSize(int maxSize) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.maxSize = maxSize;
        return clone;
    }

    public MapArbitrary<K, V> withSizeDistribution(RandomDistribution distribution) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.sizeDistribution = distribution;
        return clone;
    }

    protected Arbitrary<Map<K, V>> arbitrary() {
        SetArbitrary<K> keySetArbitrary = this.createKeySetArbitrary();
        Arbitrary keySets = keySetArbitrary.map(ArrayList::new);
        return keySets.flatMap(keys -> {
            int mapSize = keys.size();
            ListArbitrary<V> valueListArbitrary = this.createValueListArbitrary(mapSize);
            return valueListArbitrary.map(values -> {
                LinkedHashMap map = new LinkedHashMap();
                for (int i = 0; i < mapSize; ++i) {
                    Object key = keys.get(i);
                    Object value = values.get(i);
                    map.put(key, value);
                }
                return map;
            });
        });
    }

    private ListArbitrary<V> createValueListArbitrary(int size) {
        ListArbitrary valueListArbitrary = this.valuesArbitrary.list().ofSize(size);
        for (FeatureExtractor<V> extractor : this.valueUniquenessExtractors) {
            valueListArbitrary = valueListArbitrary.uniqueElements(extractor);
        }
        return valueListArbitrary;
    }

    private SetArbitrary<K> createKeySetArbitrary() {
        SetArbitrary keySetArbitrary = this.keysArbitrary.set().ofMinSize(this.minSize).ofMaxSize(this.maxSize()).withSizeDistribution(this.sizeDistribution);
        for (FeatureExtractor<K> extractor : this.keyUniquenessExtractors) {
            keySetArbitrary = keySetArbitrary.uniqueElements(extractor);
        }
        return keySetArbitrary;
    }

    private int maxSize() {
        return RandomGenerators.collectionMaxSize(this.minSize, this.maxSize);
    }

    public MapArbitrary<K, V> uniqueKeys(Function<K, Object> by) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.keyUniquenessExtractors = new LinkedHashSet<FeatureExtractor<K>>(this.keyUniquenessExtractors);
        clone.keyUniquenessExtractors.add(by::apply);
        return clone;
    }

    public MapArbitrary<K, V> uniqueValues(Function<V, Object> by) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.valueUniquenessExtractors = new LinkedHashSet<FeatureExtractor<V>>(this.valueUniquenessExtractors);
        clone.valueUniquenessExtractors.add(by::apply);
        return clone;
    }

    public MapArbitrary<K, V> uniqueValues() {
        return this.uniqueValues(FeatureExtractor.identity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultMapArbitrary that = (DefaultMapArbitrary)((Object)o);
        if (this.minSize != that.minSize) {
            return false;
        }
        if (!Objects.equals(this.maxSize, that.maxSize)) {
            return false;
        }
        if (!this.keysArbitrary.equals(that.keysArbitrary)) {
            return false;
        }
        if (!this.valuesArbitrary.equals(that.valuesArbitrary)) {
            return false;
        }
        if (!Objects.equals(this.sizeDistribution, that.sizeDistribution)) {
            return false;
        }
        if (!this.keyUniquenessExtractors.equals(that.keyUniquenessExtractors)) {
            return false;
        }
        return this.valueUniquenessExtractors.equals(that.valueUniquenessExtractors);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.minSize, (Object)this.maxSize, this.keysArbitrary, this.valuesArbitrary);
    }
}

