/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.GenericEdgeCasesConfiguration;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class IntegralEdgeCasesConfiguration
extends GenericEdgeCasesConfiguration<BigInteger> {
    private final Range<BigInteger> range;
    private final BigInteger shrinkingTarget;

    public IntegralEdgeCasesConfiguration(Range<BigInteger> range, BigInteger shrinkingTarget) {
        this.range = range;
        this.shrinkingTarget = shrinkingTarget;
    }

    @Override
    protected void checkEdgeCaseIsValid(BigInteger edgeCase) {
        if (!this.range.includes(edgeCase)) {
            String message = String.format("Edge case <%s> is outside the arbitrary's allowed range %s", edgeCase, this.range);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    protected Shrinkable<BigInteger> createShrinkable(BigInteger additionalEdgeCase) {
        return new ShrinkableBigInteger(additionalEdgeCase, this.range, this.shrinkingTarget);
    }
}

