/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;

public class LazyArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final Supplier<Arbitrary<T>> arbitrarySupplier;
    private final List<Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>> configurations = new ArrayList<Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>>();
    private Arbitrary<T> arbitrary;

    public LazyArbitrary(Supplier<Arbitrary<T>> arbitrarySupplier) {
        this.arbitrarySupplier = arbitrarySupplier;
    }

    public RandomGenerator<T> generator(int genSize) {
        return this.getArbitrary().generator(genSize);
    }

    public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.getArbitrary().generator(genSize, true);
    }

    private Arbitrary<T> getArbitrary() {
        if (this.arbitrary == null) {
            Arbitrary rawArbitrary = this.arbitrarySupplier.get();
            for (Tuple.Tuple2<ArbitraryConfigurator, TypeUsage> configuration : this.configurations) {
                ArbitraryConfigurator configurator = (ArbitraryConfigurator)configuration.get1();
                TypeUsage targetType = (TypeUsage)configuration.get2();
                rawArbitrary = SelfConfiguringArbitrary.configure(rawArbitrary, (ArbitraryConfigurator)configurator, (TypeUsage)targetType);
            }
            this.arbitrary = rawArbitrary;
        }
        return this.arbitrary;
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return this.getArbitrary().exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return EdgeCases.none();
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.configurations.add((Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>)Tuple.of((Object)configurator, (Object)targetType));
        return this;
    }
}

