/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.UniqueChars;
import net.jqwik.api.providers.TypeUsage;

public class UniqueCharsConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.canBeAssignedTo(TypeUsage.of(CharSequence.class, (TypeUsage[])new TypeUsage[0]));
    }

    public Arbitrary<? extends CharSequence> configure(Arbitrary<? extends CharSequence> arbitrary, UniqueChars uniqueChars) {
        if (arbitrary instanceof StringArbitrary) {
            return ((StringArbitrary)arbitrary).uniqueChars();
        }
        return arbitrary.filter(this::hasUniqueChars);
    }

    private boolean hasUniqueChars(CharSequence charSequence) {
        return charSequence.chars().distinct().count() == (long)charSequence.length();
    }
}

