/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.support.JqwikStringSupport;

public class Unshrinkable<T>
implements Shrinkable<T> {
    private final ShrinkingDistance distance;
    private final Supplier<T> valueSupplier;

    public Unshrinkable(Supplier<T> valueSupplier, ShrinkingDistance distance) {
        this.valueSupplier = valueSupplier;
        this.distance = distance;
    }

    public T value() {
        return this.valueSupplier.get();
    }

    public Stream<Shrinkable<T>> shrink() {
        return Stream.empty();
    }

    public ShrinkingDistance distance() {
        return this.distance;
    }

    public String toString() {
        return JqwikStringSupport.displayString(this.value());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unshrinkable that = (Unshrinkable)o;
        return Objects.equals(this.value(), that.value());
    }

    public int hashCode() {
        return Objects.hashCode(this.value());
    }
}

