/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.engine.support.LazyServiceLoaderCache;

public class RegisteredArbitraryProviders {
    private static final LazyServiceLoaderCache<ArbitraryProvider> serviceCache = new LazyServiceLoaderCache<ArbitraryProvider>(ArbitraryProvider.class);

    public static List<ArbitraryProvider> getProviders() {
        return Collections.unmodifiableList(new ArrayList<ArbitraryProvider>(serviceCache.getServices()));
    }

    public static void register(ArbitraryProvider provider) {
        if (serviceCache.getServices().contains(provider)) {
            return;
        }
        serviceCache.getServices().add(0, provider);
    }

    public static void unregister(ArbitraryProvider providerToDelete) {
        List<ArbitraryProvider> services = serviceCache.getServices();
        services.stream().filter(provider -> provider == providerToDelete).forEach(services::remove);
    }

    public static void unregister(Class<? extends ArbitraryProvider> providerClass) {
        List<ArbitraryProvider> services = serviceCache.getServices();
        services.stream().filter(provider -> provider.getClass() == providerClass).forEach(services::remove);
    }
}

