/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jqwik.engine.support.GenericsSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import net.jqwik.engine.support.TypeResolution;

public class GenericsClassContext {
    static final GenericsClassContext NULL = new GenericsClassContext(null){

        @Override
        public String toString() {
            return "GenericsContext(null)";
        }
    };
    private final Class<?> contextClass;
    private final Map<LookupTypeVariable, TypeResolution> resolutions = new LinkedHashMap<LookupTypeVariable, TypeResolution>();

    GenericsClassContext(Class<?> contextClass) {
        this.contextClass = contextClass;
    }

    public Class<?> contextClass() {
        return this.contextClass;
    }

    void addResolution(TypeVariable typeVariable, Type resolvedType, AnnotatedType annotatedType) {
        LookupTypeVariable genericVariable = new LookupTypeVariable(typeVariable);
        this.resolutions.put(genericVariable, new TypeResolution(resolvedType, annotatedType, true));
    }

    public String toString() {
        return String.format("GenericsContext(%s)", this.contextClass);
    }

    public TypeResolution resolveParameter(Parameter parameter) {
        TypeResolution initial = new TypeResolution(parameter.getParameterizedType(), parameter.getAnnotatedType(), false);
        return this.resolveType(initial);
    }

    public TypeResolution resolveReturnType(Method method) {
        TypeResolution initial = new TypeResolution(method.getGenericReturnType(), method.getAnnotatedReturnType(), false);
        return this.resolveType(initial);
    }

    private TypeResolution resolveType(TypeResolution typeResolution) {
        if (typeResolution.isVariable()) {
            return this.resolveVariable(typeResolution);
        }
        if (typeResolution.type() instanceof ParameterizedType) {
            return this.resolveParameterizedType(typeResolution);
        }
        return typeResolution;
    }

    private TypeResolution resolveParameterizedType(TypeResolution parameterizedTypeResolution) {
        ParameterizedType type = (ParameterizedType)parameterizedTypeResolution.type();
        Type[] actualTypeArguments = type.getActualTypeArguments();
        AnnotatedParameterizedType annotatedType = (AnnotatedParameterizedType)parameterizedTypeResolution.annotatedType();
        AnnotatedType[] annotatedActualTypeArguments = annotatedType == null ? new AnnotatedType[]{} : annotatedType.getAnnotatedActualTypeArguments();
        int numberOfArguments = Math.min(annotatedActualTypeArguments.length, actualTypeArguments.length);
        final ArrayList<TypeResolution> resolvedTypeArguments = new ArrayList<TypeResolution>();
        for (int i = 0; i < numberOfArguments; ++i) {
            Type typeArgument = actualTypeArguments[i];
            AnnotatedType annotatedTypeArgument = annotatedActualTypeArguments[i];
            TypeResolution typeResolution = this.resolveType(new TypeResolution(typeArgument, annotatedTypeArgument, false));
            resolvedTypeArguments.add(typeResolution);
        }
        if (resolvedTypeArguments.stream().noneMatch(TypeResolution::typeHasChanged)) {
            return parameterizedTypeResolution;
        }
        final ParameterizedTypeWrapper resolvedType = new ParameterizedTypeWrapper(type){

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])resolvedTypeArguments.stream().map(TypeResolution::type).toArray(Type[]::new);
            }
        };
        AnnotatedParameterizedTypeWrapper resolvedAnnotatedType = new AnnotatedParameterizedTypeWrapper(annotatedType){

            @Override
            public Type getType() {
                return resolvedType;
            }

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return (AnnotatedType[])resolvedTypeArguments.stream().map(TypeResolution::annotatedType).toArray(AnnotatedType[]::new);
            }
        };
        return new TypeResolution(resolvedType, resolvedAnnotatedType, true);
    }

    private TypeResolution resolveVariable(TypeResolution typeVariableResolution) {
        TypeResolution supertypeResolution;
        TypeResolution localResolution = this.resolveVariableLocally(typeVariableResolution);
        if (localResolution.isVariable() && (supertypeResolution = GenericsClassContext.resolveVariableInSupertypesOf(localResolution, this.contextClass)).typeHasChanged()) {
            return this.resolveType(supertypeResolution);
        }
        if (localResolution.typeHasChanged()) {
            return this.resolveType(localResolution);
        }
        return typeVariableResolution;
    }

    private TypeResolution resolveVariableLocally(TypeResolution typeResolution) {
        TypeVariable typeVariable = (TypeVariable)typeResolution.type();
        LookupTypeVariable variable = new LookupTypeVariable(typeVariable);
        return this.resolutions.getOrDefault(variable, typeResolution.unchanged());
    }

    private static TypeResolution resolveVariableInSupertypesOf(TypeResolution variableResolution, Class<?> clazz) {
        return GenericsClassContext.resolveVariableInTypes(variableResolution, GenericsClassContext.supertypesOf(clazz));
    }

    private static Collection<Class<?>> supertypesOf(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        LinkedHashSet supertypes = new LinkedHashSet();
        supertypes.add(clazz.getSuperclass());
        supertypes.addAll(Arrays.asList(clazz.getInterfaces()));
        return supertypes;
    }

    private static TypeResolution resolveVariableInTypes(TypeResolution variableResolution, Collection<Class<?>> superTypes) {
        for (Class<?> superType : superTypes) {
            GenericsClassContext context = GenericsSupport.contextFor(superType);
            TypeResolution resolved = context.resolveVariableLocally(variableResolution);
            if (!resolved.typeHasChanged()) continue;
            return resolved;
        }
        for (Class<?> superType : superTypes) {
            TypeResolution typeResolution = GenericsClassContext.resolveVariableInSupertypesOf(variableResolution, superType);
            if (!typeResolution.typeHasChanged()) continue;
            return typeResolution;
        }
        return variableResolution.unchanged();
    }

    private static class LookupTypeVariable {
        private final String name;
        private final GenericDeclaration declaration;

        private LookupTypeVariable(TypeVariable typeVariable) {
            this.name = typeVariable.getName();
            this.declaration = typeVariable.getGenericDeclaration();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupTypeVariable that = (LookupTypeVariable)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.declaration.equals(that.declaration);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.declaration);
        }

        public String toString() {
            return String.format("<%s>", this.name);
        }
    }

    private static class ParameterizedTypeWrapper
    implements ParameterizedType {
        private final ParameterizedType wrapped;

        private ParameterizedTypeWrapper(ParameterizedType wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.wrapped.getActualTypeArguments();
        }

        @Override
        public Type getRawType() {
            return this.wrapped.getRawType();
        }

        @Override
        public Type getOwnerType() {
            return this.wrapped.getOwnerType();
        }

        public String toString() {
            String baseString = JqwikStringSupport.displayString(this.getRawType());
            String typeArgumentsString = Arrays.stream(this.getActualTypeArguments()).map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
            return String.format("%s<%s>", baseString, typeArgumentsString);
        }
    }

    private static class AnnotatedParameterizedTypeWrapper
    implements AnnotatedParameterizedType {
        private final AnnotatedParameterizedType annotatedType;

        private AnnotatedParameterizedTypeWrapper(AnnotatedParameterizedType annotatedType) {
            this.annotatedType = annotatedType;
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            return this.annotatedType.getAnnotatedActualTypeArguments();
        }

        @Override
        public Type getType() {
            return this.annotatedType.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.annotatedType.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotatedType.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.annotatedType.getDeclaredAnnotations();
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }

        public String toString() {
            String typeString = JqwikStringSupport.displayString(this.getType());
            String annotationsString = Arrays.stream(this.getAnnotations()).map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
            return String.format("%s %s", annotationsString, typeString);
        }
    }
}

