/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.jqwik.api.Report;
import net.jqwik.api.Reporting;
import net.jqwik.api.domains.Domain;
import net.jqwik.engine.descriptor.DiscoverySupport;
import net.jqwik.engine.descriptor.JqwikDescriptor;
import net.jqwik.engine.support.JqwikKotlinSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;

abstract class AbstractMethodDescriptor
extends AbstractTestDescriptor
implements JqwikDescriptor {
    private final Method targetMethod;
    private final Class<?> containerClass;
    private final Set<TestTag> tags;
    private final Set<Domain> domains;

    AbstractMethodDescriptor(UniqueId uniqueId, Method targetMethod, Class<?> containerClass) {
        super(uniqueId, AbstractMethodDescriptor.determineDisplayName(targetMethod), (TestSource)MethodSource.from((Method)targetMethod));
        this.tags = DiscoverySupport.findTestTags(targetMethod);
        this.domains = DiscoverySupport.findDomains(targetMethod);
        this.containerClass = containerClass;
        this.targetMethod = targetMethod;
    }

    private static String determineDisplayName(Method targetMethod) {
        Supplier<String> defaultNameSupplier = () -> AbstractMethodDescriptor.getDefaultName(targetMethod);
        return DiscoverySupport.determineLabel(targetMethod, defaultNameSupplier);
    }

    private static String getDefaultName(Method targetMethod) {
        return JqwikKotlinSupport.javaOrKotlinName(targetMethod);
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public String getLabel() {
        return this.getDisplayName();
    }

    public String extendedLabel() {
        return this.getParent().map(parent -> parent.getDisplayName() + ":" + this.getLabel()).orElse(this.getLabel());
    }

    public Set<TestTag> getTags() {
        return DiscoverySupport.getTags(this.getParent(), this.tags);
    }

    @Override
    public Set<Domain> getDomains() {
        return DiscoverySupport.getDomains(this.getJqwikParent(), this.domains);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Reporting[] getReporting() {
        Optional optionalReport = AnnotationSupport.findAnnotation((AnnotatedElement)this.getTargetMethod(), Report.class);
        return optionalReport.map(Report::value).orElse(new Reporting[0]);
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.getTargetMethod();
    }
}

