/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.ForAll;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Reporter;
import net.jqwik.api.Reporting;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.execution.AfterFailureParametersGenerator;
import net.jqwik.engine.execution.DefaultTryLifecycleContext;
import net.jqwik.engine.execution.GenerationInfo;
import net.jqwik.engine.execution.ParametersGenerator;
import net.jqwik.engine.execution.ResolvingParametersGenerator;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.DataBasedShrinkablesGenerator;
import net.jqwik.engine.properties.ExhaustiveShrinkablesGenerator;
import net.jqwik.engine.properties.FailOnFixedSeedException;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.GenericProperty;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.properties.RandomizedShrinkablesGenerator;
import net.jqwik.engine.support.MethodParameter;

public class CheckedProperty {
    private static final Logger LOG = Logger.getLogger(CheckedProperty.class.getName());
    public final String propertyName;
    public final TryLifecycleExecutor tryLifecycleExecutor;
    public final List<MethodParameter> propertyParameters;
    public final List<MethodParameter> forAllParameters;
    public final PropertyConfiguration configuration;
    private final ArbitraryResolver arbitraryResolver;
    private final ResolveParameterHook resolveParameterHook;
    private final PropertyLifecycleContext propertyLifecycleContext;
    private final Optional<Iterable<? extends Tuple>> optionalData;
    private Optional<ExhaustiveShrinkablesGenerator> optionalExhaustive;

    public CheckedProperty(String propertyName, TryLifecycleExecutor tryLifecycleExecutor, List<MethodParameter> propertyParameters, ArbitraryResolver arbitraryResolver, ResolveParameterHook resolveParameterHook, PropertyLifecycleContext propertyLifecycleContext, Optional<Iterable<? extends Tuple>> optionalData, PropertyConfiguration configuration) {
        this.propertyName = propertyName;
        this.tryLifecycleExecutor = tryLifecycleExecutor;
        this.propertyParameters = propertyParameters;
        this.forAllParameters = this.selectForAllParameters(propertyParameters);
        this.arbitraryResolver = arbitraryResolver;
        this.resolveParameterHook = resolveParameterHook;
        this.propertyLifecycleContext = propertyLifecycleContext;
        this.optionalData = optionalData;
        this.configuration = configuration;
    }

    private List<MethodParameter> selectForAllParameters(List<MethodParameter> propertyParameters) {
        return propertyParameters.stream().filter(parameter -> parameter.isAnnotated(ForAll.class)).collect(Collectors.toList());
    }

    public PropertyCheckResult check(Reporting[] reporting) {
        PropertyConfiguration effectiveConfiguration;
        try {
            effectiveConfiguration = this.configurationWithEffectiveSeed();
        }
        catch (FailOnFixedSeedException failOnFixedSeedException) {
            return this.failed(this.configuration, failOnFixedSeedException);
        }
        this.maybeWarnOnMultipleTriesWithoutForallParameters(effectiveConfiguration);
        try {
            Reporter reporter = this.propertyLifecycleContext.reporter();
            return this.createGenericProperty(effectiveConfiguration).check(reporter, reporting);
        }
        catch (CannotFindArbitraryException | TooManyFilterMissesException generationFailedException) {
            return this.failed(effectiveConfiguration, (JqwikException)generationFailedException);
        }
    }

    private PropertyCheckResult failed(PropertyConfiguration configuration, JqwikException exception) {
        return PropertyCheckResult.failed(configuration.getStereotype(), this.propertyName, 0, 0, new GenerationInfo(configuration.getSeed()), configuration.getGenerationMode(), configuration.getEdgeCasesMode(), 0, 0, null, null, exception);
    }

    private void maybeWarnOnMultipleTriesWithoutForallParameters(PropertyConfiguration effectiveConfiguration) {
        if (effectiveConfiguration.getTries() > 1 && this.forAllParameters.isEmpty()) {
            String message = String.format("Running %s [%s] in container [%s] without any @ForAll parameters for %s tries.%n    Maybe you want to change it into an @Example?", effectiveConfiguration.getStereotype(), this.propertyLifecycleContext.extendedLabel(), this.propertyLifecycleContext.containerClass().getName(), effectiveConfiguration.getTries());
            LOG.warning(message);
        }
    }

    private PropertyConfiguration configurationWithEffectiveSeed() {
        if (this.configuration.hasFixedSeed()) {
            this.applyFixedSeedMode(this.configuration);
            return this.configuration.withFixedSeed();
        }
        if (this.configuration.previousFailureMustBeHandled()) {
            return this.configuration.withPreviousGenerationSeed();
        }
        return this.configuration.withSeed(SourceOfRandomness.createRandomSeed());
    }

    private void applyFixedSeedMode(PropertyConfiguration configuration) {
        switch (configuration.getFixedSeedMode()) {
            case FAIL: {
                String message = String.format("Failing %s [%s] in container [%s] as the fixed seed mode is set to FAIL", configuration.getStereotype(), this.propertyLifecycleContext.extendedLabel(), this.propertyLifecycleContext.containerClass().getName());
                throw new FailOnFixedSeedException(message);
            }
            case WARN: {
                String message = String.format("Using fixed seed for %s [%s] in container [%s]", configuration.getStereotype(), this.propertyLifecycleContext.extendedLabel(), this.propertyLifecycleContext.containerClass().getName());
                LOG.warning(message);
                break;
            }
        }
    }

    private GenericProperty createGenericProperty(PropertyConfiguration effectiveConfiguration) {
        boolean useAfterFailureGenerator;
        if (effectiveConfiguration.getGenerationMode() == GenerationMode.RANDOMIZED) {
            this.ensureValidRandomizedMode();
        } else if (effectiveConfiguration.getGenerationMode() == GenerationMode.DATA_DRIVEN) {
            this.ensureValidDataDrivenMode();
        } else if (effectiveConfiguration.getGenerationMode() == GenerationMode.EXHAUSTIVE) {
            this.ensureValidExhaustiveMode();
            effectiveConfiguration = effectiveConfiguration.withTries(Math.toIntExact(this.getOptionalExhaustive().get().maxCount()));
        } else if (effectiveConfiguration.getGenerationMode() == GenerationMode.AUTO) {
            effectiveConfiguration = this.chooseGenerationMode(effectiveConfiguration);
        }
        ForAllParametersGenerator forAllParametersGenerator = this.createForAllParametersGenerator(effectiveConfiguration);
        ParametersGenerator parametersGenerator = new ResolvingParametersGenerator(this.propertyParameters, forAllParametersGenerator, this.resolveParameterHook, this.propertyLifecycleContext);
        boolean bl = useAfterFailureGenerator = effectiveConfiguration.previousFailureMustBeHandled() && !this.forAllParameters.isEmpty() && effectiveConfiguration.seedHasNotChanged();
        if (useAfterFailureGenerator) {
            parametersGenerator = new AfterFailureParametersGenerator(this.configuration.getAfterFailureMode(), this.configuration.getPreviousFailureGeneration(), parametersGenerator);
        }
        Supplier<TryLifecycleContext> tryLifecycleContextSupplier = () -> new DefaultTryLifecycleContext(this.propertyLifecycleContext);
        return new GenericProperty(this.propertyName, effectiveConfiguration, parametersGenerator, this.tryLifecycleExecutor, tryLifecycleContextSupplier);
    }

    private ForAllParametersGenerator createForAllParametersGenerator(PropertyConfiguration effectiveConfiguration) {
        switch (effectiveConfiguration.getGenerationMode()) {
            case EXHAUSTIVE: {
                return this.getOptionalExhaustive().get();
            }
            case DATA_DRIVEN: {
                return this.createDataBasedShrinkablesGenerator(effectiveConfiguration);
            }
        }
        return this.createRandomizedShrinkablesGenerator(effectiveConfiguration);
    }

    private void ensureValidRandomizedMode() {
        if (this.optionalData.isPresent()) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = RANDOMIZED)");
        }
    }

    private void ensureValidExhaustiveMode() {
        if (this.optionalData.isPresent()) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = EXHAUSTIVE)");
        }
        if (!this.getOptionalExhaustive().isPresent()) {
            throw new JqwikException("EXHAUSTIVE generation is not possible. Maybe too many potential examples?");
        }
    }

    private void ensureValidDataDrivenMode() {
        if (!this.optionalData.isPresent()) {
            throw new JqwikException("With @Property(generation = DATA_DRIVEN) there must be a @FromData annotation");
        }
    }

    private PropertyConfiguration chooseGenerationMode(PropertyConfiguration configuration) {
        configuration = this.optionalData.isPresent() ? configuration.withGenerationMode(GenerationMode.DATA_DRIVEN) : (this.getOptionalExhaustive().isPresent() && this.getOptionalExhaustive().get().maxCount() <= (long)configuration.getTries() ? configuration.withGenerationMode(GenerationMode.EXHAUSTIVE) : configuration.withGenerationMode(GenerationMode.RANDOMIZED));
        return configuration;
    }

    private Optional<ExhaustiveShrinkablesGenerator> createOptionalExhaustiveShrinkablesGenerator(long maxNumberOfSamples) {
        if (this.forAllParameters.isEmpty()) {
            return Optional.empty();
        }
        try {
            ExhaustiveShrinkablesGenerator exhaustiveShrinkablesGenerator = ExhaustiveShrinkablesGenerator.forParameters(this.forAllParameters, this.arbitraryResolver, maxNumberOfSamples);
            return Optional.of(exhaustiveShrinkablesGenerator);
        }
        catch (TooManyFilterMissesException tmfme) {
            throw tmfme;
        }
        catch (JqwikException ex) {
            return Optional.empty();
        }
    }

    private ForAllParametersGenerator createDataBasedShrinkablesGenerator(PropertyConfiguration configuration) {
        if (configuration.getGenerationMode() != GenerationMode.DATA_DRIVEN) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = RANDOMIZED)");
        }
        return new DataBasedShrinkablesGenerator(this.forAllParameters, this.optionalData.get());
    }

    private ForAllParametersGenerator createRandomizedShrinkablesGenerator(PropertyConfiguration configuration) {
        Random random = SourceOfRandomness.create(configuration.getSeed());
        return RandomizedShrinkablesGenerator.forParameters(this.forAllParameters, this.arbitraryResolver, random, configuration.getTries(), configuration.getEdgeCasesMode());
    }

    private Optional<ExhaustiveShrinkablesGenerator> getOptionalExhaustive() {
        if (this.optionalExhaustive == null) {
            long maxNumberOfSamples = this.configuration.getGenerationMode() == GenerationMode.EXHAUSTIVE ? Integer.MAX_VALUE : (long)this.configuration.getTries();
            this.optionalExhaustive = this.createOptionalExhaustiveShrinkablesGenerator(maxNumberOfSamples);
        }
        return this.optionalExhaustive;
    }
}

