/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.TestDescriptor;

public class ScopedStore<T>
implements Store<T> {
    private static final Logger LOG = Logger.getLogger(ScopedStore.class.getName());
    private final Object identifier;
    private final Lifespan lifespan;
    private final TestDescriptor scope;
    private final Supplier<? extends T> initialValueSupplier;
    private T value;
    private boolean initialized = false;

    public ScopedStore(Object identifier, Lifespan lifespan, TestDescriptor scope, Supplier<? extends T> initialValueSupplier) {
        this.identifier = identifier;
        this.lifespan = lifespan;
        this.scope = scope;
        this.initialValueSupplier = initialValueSupplier;
    }

    public synchronized T get() {
        if (!this.initialized) {
            this.value = this.initialValueSupplier.get();
            this.initialized = true;
        }
        return this.value;
    }

    public Lifespan lifespan() {
        return this.lifespan;
    }

    public synchronized void update(Function<T, T> updater) {
        this.value = updater.apply(this.get());
    }

    public synchronized void reset() {
        this.close();
        this.initialized = false;
        this.value = null;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public TestDescriptor getScope() {
        return this.scope;
    }

    public boolean isVisibleFor(TestDescriptor retriever) {
        return this.isInScope(retriever);
    }

    private boolean isInScope(TestDescriptor retriever) {
        if (retriever == this.scope) {
            return true;
        }
        return retriever.getParent().map(this::isInScope).orElse(false);
    }

    public String toString() {
        return String.format("Store(%s, %s, %s): [%s]", JqwikStringSupport.displayString(this.identifier), this.lifespan.name(), this.scope.getUniqueId(), JqwikStringSupport.displayString(this.value));
    }

    public void close() {
        if (!this.initialized) {
            return;
        }
        this.closeOnReset();
    }

    private void closeOnReset() {
        if (this.value instanceof Store.CloseOnReset) {
            try {
                ((Store.CloseOnReset)this.value).close();
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                String message = String.format("Exception while closing store [%s]", this);
                LOG.log(Level.SEVERE, message, throwable);
            }
        }
    }
}

