/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.statistics;

import java.util.List;
import net.jqwik.api.Reporter;
import net.jqwik.api.Tuple;
import net.jqwik.api.statistics.StatisticsEntry;
import net.jqwik.api.statistics.StatisticsReportFormat;
import net.jqwik.engine.hooks.statistics.StatisticsCollectorImpl;

public class StatisticsPublisher {
    private final StatisticsReportFormat statisticsReportFormat;
    private final List<StatisticsEntry> entries;
    private final int countCollects;
    private final String label;

    public StatisticsPublisher(StatisticsCollectorImpl statisticsCollector, StatisticsReportFormat statisticsReportFormat) {
        this(statisticsReportFormat, statisticsCollector.statisticsEntries(), statisticsCollector.countAllCollects(), statisticsCollector.label());
    }

    private StatisticsPublisher(StatisticsReportFormat statisticsReportFormat, List<? extends StatisticsEntry> entries, int countCollects, String label) {
        this.statisticsReportFormat = statisticsReportFormat;
        this.entries = entries;
        this.countCollects = countCollects;
        this.label = label;
    }

    public void publish(Reporter reporter, String propertyName) {
        String report = this.createReport();
        String reportEntryKey = this.createReportEntryKey(propertyName);
        Tuple.Tuple2 reportEntry = Tuple.of((Object)reportEntryKey, (Object)report);
        if (report.isEmpty()) {
            return;
        }
        reporter.publishValue((String)reportEntry.get1(), (String)reportEntry.get2());
    }

    private String createReport() {
        List reportLines = this.statisticsReportFormat.formatReport(this.entries);
        StringBuilder report = new StringBuilder();
        for (String reportLine : reportLines) {
            report.append(this.formatReportLine(reportLine));
        }
        return report.toString();
    }

    private String formatReportLine(String line) {
        return String.format("%n    %s", line);
    }

    private String createReportEntryKey(String propertyName) {
        return String.format("[%s] (%d) %s", propertyName, this.countCollects, this.label);
    }
}

