/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface FeatureExtractor<T>
extends Function<T, Object> {
    public static <T> FeatureExtractor<T> identity() {
        return t -> t;
    }

    default public Object applySafe(T t) {
        try {
            return this.apply(t);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    default public boolean isUniqueIn(T value, Collection<? extends T> elements) {
        if (this == FeatureExtractor.identity()) {
            return !elements.contains(value);
        }
        Object feature = this.applySafe(value);
        return elements.stream().map(this::applySafe).noneMatch(x -> Objects.equals(x, feature));
    }

    default public boolean areUnique(Collection<? extends T> elements) {
        HashSet<Object> set = new HashSet<Object>();
        for (T x : elements) {
            if (set.add(this.applySafe(x))) continue;
            return false;
        }
        return true;
    }
}

