/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.UseGeneratorsArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class ChooseCharacterArbitrary
extends UseGeneratorsArbitrary<Character> {
    private final char[] chars;

    public ChooseCharacterArbitrary(char[] chars) {
        super(RandomGenerators.choose(chars), max -> ExhaustiveGenerators.choose(chars, (long)max), maxEdgeCases -> {
            ArrayList<Character> validCharacters = new ArrayList<Character>(chars.length);
            for (char character : chars) {
                validCharacters.add(Character.valueOf(character));
            }
            return EdgeCasesSupport.choose(validCharacters, maxEdgeCases);
        });
        this.chars = chars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChooseCharacterArbitrary that = (ChooseCharacterArbitrary)o;
        return Arrays.equals(this.chars, that.chars);
    }

    public int hashCode() {
        return Arrays.hashCode(this.chars);
    }
}

