/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.IntegralEdgeCasesConfiguration;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class IntegralGeneratingArbitrary
extends TypedCloneable
implements Arbitrary<BigInteger> {
    BigInteger min;
    BigInteger max;
    BigInteger shrinkingTarget;
    RandomDistribution distribution = RandomDistribution.biased();
    private Consumer<? super EdgeCases.Config<BigInteger>> edgeCasesConfigurator = EdgeCases.Config.noConfig();

    IntegralGeneratingArbitrary(BigInteger defaultMin, BigInteger defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
        this.shrinkingTarget = null;
    }

    public RandomGenerator<BigInteger> generator(int genSize) {
        return RandomGenerators.bigIntegers(this.min, this.max, this.shrinkingTarget(), this.distribution);
    }

    public Optional<ExhaustiveGenerator<BigInteger>> exhaustive(long maxNumberOfSamples) {
        BigInteger maxCount = this.max.subtract(this.min).add(BigInteger.ONE);
        if (maxCount.compareTo(BigInteger.valueOf(maxNumberOfSamples)) > 0) {
            return Optional.empty();
        }
        return ExhaustiveGenerators.fromIterable(() -> new RangeIterator(), maxCount.longValueExact(), maxNumberOfSamples);
    }

    public EdgeCases<BigInteger> edgeCases(int maxEdgeCases) {
        Range<BigInteger> range = Range.of(this.min, this.max);
        BigInteger shrinkingTarget = this.shrinkingTarget();
        Function<Integer, EdgeCases> edgeCasesCreator = m -> {
            List shrinkables = this.streamDefaultEdgeCases().map(value -> new ShrinkableBigInteger((BigInteger)value, range, shrinkingTarget)).limit(Math.max(0, m)).collect(Collectors.toList());
            return EdgeCasesSupport.fromShrinkables(shrinkables);
        };
        IntegralEdgeCasesConfiguration configuration = new IntegralEdgeCasesConfiguration(range, shrinkingTarget);
        return configuration.configure(this.edgeCasesConfigurator, edgeCasesCreator, maxEdgeCases);
    }

    public Arbitrary<BigInteger> edgeCases(Consumer<EdgeCases.Config<BigInteger>> configurator) {
        IntegralGeneratingArbitrary clone = (IntegralGeneratingArbitrary)this.typedClone();
        clone.edgeCasesConfigurator = configurator;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegralGeneratingArbitrary that = (IntegralGeneratingArbitrary)o;
        if (!this.min.equals(that.min)) {
            return false;
        }
        if (!this.max.equals(that.max)) {
            return false;
        }
        if (!Objects.equals(this.shrinkingTarget, that.shrinkingTarget)) {
            return false;
        }
        if (!this.distribution.equals((Object)that.distribution)) {
            return false;
        }
        return LambdaSupport.areEqual(this.edgeCasesConfigurator, that.edgeCasesConfigurator);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.min, (Object)this.max, (Object)this.shrinkingTarget);
    }

    private Stream<BigInteger> streamDefaultEdgeCases() {
        return this.streamRawEdgeCases().distinct().filter(aBigInt -> aBigInt.compareTo(this.min) >= 0 && aBigInt.compareTo(this.max) <= 0);
    }

    private Stream<BigInteger> streamRawEdgeCases() {
        BigInteger[] literalEdgeCases = new BigInteger[]{BigInteger.valueOf(-2L), BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.valueOf(2L), BigInteger.valueOf(1L), this.min, this.min.add(BigInteger.ONE), this.max, this.max.subtract(BigInteger.ONE)};
        return this.shrinkingTarget == null ? Arrays.stream(literalEdgeCases) : Stream.concat(Stream.of(this.shrinkingTarget), Arrays.stream(literalEdgeCases));
    }

    private BigInteger shrinkingTarget() {
        if (this.shrinkingTarget == null) {
            return RandomIntegralGenerators.defaultShrinkingTarget(Range.of(this.min, this.max));
        }
        return this.shrinkingTarget;
    }

    class RangeIterator
    implements Iterator<BigInteger> {
        BigInteger current;

        RangeIterator() {
            this.current = IntegralGeneratingArbitrary.this.min;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(IntegralGeneratingArbitrary.this.max) <= 0;
        }

        @Override
        public BigInteger next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BigInteger next = this.current;
            this.current = this.current.add(BigInteger.ONE);
            return next;
        }
    }
}

