/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.support.JqwikExceptionSupport;

public class IgnoreExceptionExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private final ExhaustiveGenerator<T> toFilter;
    private final Class<? extends Throwable>[] exceptionTypes;
    private final int maxThrows;

    public IgnoreExceptionExhaustiveGenerator(ExhaustiveGenerator<T> toFilter, Class<? extends Throwable>[] exceptionTypes, int maxThrows) {
        this.toFilter = toFilter;
        this.exceptionTypes = exceptionTypes;
        this.maxThrows = maxThrows;
    }

    public long maxCount() {
        return this.toFilter.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.toFilter.iterator();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                for (int i = 0; i < IgnoreExceptionExhaustiveGenerator.this.maxThrows; ++i) {
                    if (!mappedIterator.hasNext()) {
                        return null;
                    }
                    try {
                        return mappedIterator.next();
                    }
                    catch (Throwable throwable) {
                        if (JqwikExceptionSupport.isInstanceOfAny(throwable, IgnoreExceptionExhaustiveGenerator.this.exceptionTypes)) continue;
                        throw throwable;
                    }
                }
                String message = String.format("Filter missed more than %s times.", IgnoreExceptionExhaustiveGenerator.this.maxThrows);
                throw new TooManyFilterMissesException(message);
            }
        };
    }
}

