/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.state.Action;
import net.jqwik.api.state.ActionChain;
import net.jqwik.api.state.ActionChainArbitrary;
import net.jqwik.api.state.ChainArbitrary;
import net.jqwik.api.state.ChangeDetector;
import net.jqwik.api.state.Transformation;
import net.jqwik.api.state.Transformer;
import net.jqwik.engine.properties.state.DefaultChainArbitrary;
import net.jqwik.engine.properties.state.SequentialActionChain;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class DefaultActionChainArbitrary<T>
extends ArbitraryDecorator<ActionChain<T>>
implements ActionChainArbitrary<T> {
    private ChainArbitrary<T> chainArbitrary;

    public DefaultActionChainArbitrary(Supplier<? extends T> initialSupplier) {
        this.chainArbitrary = new DefaultChainArbitrary<T>(initialSupplier);
    }

    private Transformation<T> createTransformation(Action<T> action) {
        this.checkActionIsConsistent(action);
        Optional<Predicate<Predicate>> optionalPrecondition = this.precondition(action);
        return optionalPrecondition.map(precondition -> Transformation.when((Predicate)precondition).provide(state -> this.toTransformerArbitrary(action, () -> state))).orElseGet(() -> supplier -> this.toTransformerArbitrary(action, (Supplier<T>)supplier));
    }

    private Optional<Predicate<T>> precondition(Action<T> action) {
        try {
            Method precondition = this.preconditionMethod(action.getClass());
            if (!precondition.equals(this.preconditionMethod(Action.class))) {
                return Optional.of(state -> {
                    try {
                        return (Boolean)ReflectionSupport.invokeMethod((Method)precondition, (Object)action, (Object[])new Object[]{state});
                    }
                    catch (Exception exception) {
                        return (Boolean)JqwikExceptionSupport.throwAsUncheckedException(exception);
                    }
                });
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private void checkActionIsConsistent(Action<T> action) {
        if (!(action instanceof Action.Dependent) && !(action instanceof Action.Independent)) {
            String message = String.format("Action <%s> must implement exactly one of type Action.Dependent or Action.Independent,but implements neither.", action);
            throw new IllegalArgumentException(message);
        }
        if (action instanceof Action.Dependent && action instanceof Action.Independent) {
            String message = String.format("Action <%s> must implement exactly one of type Action.Dependent or Action.Independent,but implements both.", action);
            throw new IllegalArgumentException(message);
        }
    }

    private Arbitrary<Transformer<T>> toTransformerArbitrary(Action<T> action, Supplier<T> stateSupplier) {
        if (action instanceof Action.Independent) {
            Action.Independent independentAction = (Action.Independent)action;
            return independentAction.transformer();
        }
        if (action instanceof Action.Dependent) {
            Action.Dependent dependentAction = (Action.Dependent)action;
            return dependentAction.transformer(stateSupplier.get());
        }
        throw new RuntimeException("Should never get here. Should be caught before by checkActionIsConsistent()");
    }

    private Method preconditionMethod(Class<?> aClass) throws NoSuchMethodException {
        return aClass.getMethod("precondition", Object.class);
    }

    public ActionChainArbitrary<T> withAction(int weight, Action<T> action) {
        DefaultActionChainArbitrary clone = (DefaultActionChainArbitrary)this.typedClone();
        clone.chainArbitrary = clone.chainArbitrary.withTransformation(weight, this.createTransformation(action));
        return clone;
    }

    public ActionChainArbitrary<T> withMaxTransformations(int maxSize) {
        DefaultActionChainArbitrary clone = (DefaultActionChainArbitrary)this.typedClone();
        clone.chainArbitrary = clone.chainArbitrary.withMaxTransformations(maxSize);
        return clone;
    }

    public ActionChainArbitrary<T> improveShrinkingWith(Supplier<ChangeDetector<T>> changeDetectorSupplier) {
        DefaultActionChainArbitrary clone = (DefaultActionChainArbitrary)this.typedClone();
        clone.chainArbitrary = clone.chainArbitrary.improveShrinkingWith(changeDetectorSupplier);
        return clone;
    }

    protected Arbitrary<ActionChain<T>> arbitrary() {
        return this.chainArbitrary.map(SequentialActionChain::new);
    }

    public boolean isGeneratorMemoizable() {
        return false;
    }
}

