/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.5.4")
public interface InstantArbitrary
extends Arbitrary<Instant> {
    default public InstantArbitrary between(Instant min, Instant max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public InstantArbitrary atTheEarliest(Instant var1);

    public InstantArbitrary atTheLatest(Instant var1);

    public InstantArbitrary dateBetween(LocalDate var1, LocalDate var2);

    public InstantArbitrary yearBetween(Year var1, Year var2);

    default public InstantArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public InstantArbitrary monthBetween(Month var1, Month var2);

    default public InstantArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public InstantArbitrary onlyMonths(Month ... var1);

    public InstantArbitrary dayOfMonthBetween(int var1, int var2);

    public InstantArbitrary onlyDaysOfWeek(DayOfWeek ... var1);

    public InstantArbitrary timeBetween(LocalTime var1, LocalTime var2);

    public InstantArbitrary hourBetween(int var1, int var2);

    public InstantArbitrary minuteBetween(int var1, int var2);

    public InstantArbitrary secondBetween(int var1, int var2);

    public InstantArbitrary ofPrecision(ChronoUnit var1);
}

