/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.YearMonth;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.api.constraints.YearMonthRange;

public class YearMonthRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(YearMonth.class);
    }

    public Arbitrary<YearMonth> configure(Arbitrary<YearMonth> arbitrary, YearMonthRange range) {
        YearMonth min = this.isoDateToYearMonth(range.min());
        YearMonth max = this.isoDateToYearMonth(range.max());
        if (arbitrary instanceof YearMonthArbitrary) {
            YearMonthArbitrary yearMonthArbitrary = (YearMonthArbitrary)arbitrary;
            return yearMonthArbitrary.between(min, max);
        }
        return arbitrary.filter(v -> this.filter((YearMonth)v, min, max));
    }

    private YearMonth isoDateToYearMonth(String iso) {
        return YearMonth.parse(iso);
    }

    private boolean filter(YearMonth yearMonth, YearMonth min, YearMonth max) {
        return !yearMonth.isBefore(min) && !yearMonth.isAfter(max);
    }
}

