/**
 * Copyright 2014-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import net.kaczmarzyk.spring.data.jpa.utils.Converter;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;


/**
 * <p>Filers with "is null" or "is not null" where clause (e.g. {@code where nickName is null}).</p>
 *
 * <p>Requires boolean parameter.</p>
 *
 * @author Tomasz Kaczmarzyk
 * @author Gerald Humphries
 */
public class Null<T> extends PathSpecification<T> {

	protected String expectedValue;
	private Converter converter;

	public Null(String path, String[] httpParamValues, Converter converter) {
		super(path);
		if (httpParamValues == null || httpParamValues.length != 1) {
			throw new IllegalArgumentException();
		}
		this.expectedValue = httpParamValues[0];
		this.converter = converter;
	}

	@Override
	public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
		if (converter.convert(expectedValue, Boolean.class)) {
			return cb.isNull(path(root));
		} else {
			return cb.isNotNull(path(root));
		}
	}

}
