/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class Conjunction<T>
implements Specification<T> {
    private Collection<Specification<T>> innerSpecs;

    @SafeVarargs
    public Conjunction(Specification<T> ... innerSpecs) {
        this(Arrays.asList(innerSpecs));
    }

    public Conjunction(Collection<Specification<T>> innerSpecs) {
        this.innerSpecs = innerSpecs;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Specifications combinedSpecs = null;
        for (Specification<T> spec : this.innerSpecs) {
            if (combinedSpecs == null) {
                combinedSpecs = Specifications.where(spec);
                continue;
            }
            combinedSpecs = combinedSpecs.and(spec);
        }
        return combinedSpecs.toPredicate(root, query, cb);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.innerSpecs == null ? 0 : this.innerSpecs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjunction other = (Conjunction)obj;
        return !(this.innerSpecs == null ? other.innerSpecs != null : !this.innerSpecs.equals(other.innerSpecs));
    }
}

