/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.Map;
import java.util.Objects;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.JsonReadingUtils;
import net.logstash.logback.composite.ObjectMapperAware;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TreeNode;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ObjectNode;

public class GlobalCustomFieldsJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements ObjectMapperAware {
    private String customFields;
    private ObjectNode customFieldsNode;
    private ObjectMapper objectMapper;

    @Override
    public void writeTo(JsonGenerator generator, Event event) {
        this.writeFieldsOfNode(generator, (JsonNode)this.customFieldsNode);
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) {
        if (node != null) {
            for (Map.Entry field : node.properties()) {
                generator.writeName((String)field.getKey());
                generator.writeTree((TreeNode)field.getValue());
            }
        }
    }

    @Override
    public void start() {
        this.initializeCustomFields();
        super.start();
    }

    private void initializeCustomFields() {
        if (this.customFieldsNode != null || this.customFields == null) {
            return;
        }
        if (this.objectMapper == null) {
            throw new IllegalStateException("objectMapper has not been set");
        }
        try {
            this.customFieldsNode = JsonReadingUtils.readFullyAsObjectNode(this.objectMapper, this.customFields);
        }
        catch (StreamReadException e) {
            this.addError("[customFields] is not a valid JSON object", e);
        }
    }

    public void setCustomFields(String customFields) {
        if (this.isStarted()) {
            throw new IllegalStateException("Configuration cannot be changed while the provider is started");
        }
        this.customFields = customFields;
        this.customFieldsNode = null;
    }

    public String getCustomFields() {
        return this.customFields;
    }

    public ObjectNode getCustomFieldsNode() {
        return this.customFieldsNode;
    }

    @Deprecated
    public void setCustomFieldsNode(JsonNode customFields) {
        if (customFields != null && !(customFields instanceof ObjectNode)) {
            throw new IllegalArgumentException("Must be an ObjectNode");
        }
        this.setCustomFieldsNode((ObjectNode)customFields);
    }

    public void setCustomFieldsNode(ObjectNode customFields) {
        if (this.isStarted()) {
            throw new IllegalStateException("Configuration cannot be changed while the provider is started");
        }
        this.customFieldsNode = customFields;
        this.customFields = null;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }
}

