/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;
import tools.jackson.core.JsonGenerator;

public class LogstashMarkersJsonProvider
extends AbstractJsonProvider<ILoggingEvent> {
    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        this.writeLogstashMarkerIfNecessary(generator, event.getMarkerList());
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, List<Marker> markers) {
        if (markers != null) {
            for (Marker marker : markers) {
                this.writeLogstashMarkerIfNecessary(generator, marker);
            }
        }
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) {
        if (marker != null) {
            if (LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator);
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    public static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }
}

