/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.ltgt.gradle.apt.AptPlugin;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.util.GradleVersion;

public class AptIdeaPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(IdeaPlugin.class);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
                SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
                AptIdeaPlugin.this.configureIdeaModule(project, mainSourceSet, testSourceSet);
            }
        });
        this.configureIdeaProject(project);
    }

    private void configureIdeaModule(Project project, final SourceSet mainSourceSet, final SourceSet testSourceSet) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                IdeaModule ideaModule = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getModule();
                LinkedHashSet<File> excl = new LinkedHashSet<File>();
                for (SourceSet sourceSet : new SourceSet[]{mainSourceSet, testSourceSet}) {
                    File generatedSourcesDir;
                    for (File f = generatedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir(); f != null && f != project.getProjectDir(); f = f.getParentFile()) {
                        excl.add(f);
                    }
                }
                LinkedHashSet<File> excludeDirs = new LinkedHashSet<File>(ideaModule.getExcludeDirs());
                if (excl.contains(project.getBuildDir()) && ideaModule.getExcludeDirs().contains(project.getBuildDir())) {
                    ideaModule.getExcludeDirs().remove(project.getBuildDir());
                    File[] subdirs = project.getBuildDir().listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    if (subdirs != null) {
                        excludeDirs.addAll(Arrays.asList(subdirs));
                    }
                }
                excludeDirs.removeAll(excl);
                ideaModule.setExcludeDirs(excludeDirs);
                File mainGeneratedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)mainSourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
                File testGeneratedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)testSourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
                ideaModule.setSourceDirs(this.addToSet(ideaModule.getSourceDirs(), mainGeneratedSourcesDir));
                ideaModule.setTestSourceDirs(this.addToSet(ideaModule.getTestSourceDirs(), testGeneratedSourcesDir));
                ideaModule.setGeneratedSourceDirs(this.addToSet(ideaModule.getGeneratedSourceDirs(), mainGeneratedSourcesDir, testGeneratedSourcesDir));
                AptPlugin.AptSourceSetConvention mainSourceSetConvention = (AptPlugin.AptSourceSetConvention)new DslObject((Object)mainSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class);
                AptPlugin.AptSourceSetConvention testSourceSetConvention = (AptPlugin.AptSourceSetConvention)new DslObject((Object)testSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class);
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0) {
                    ((Collection)((Map)ideaModule.getScopes().get("PROVIDED")).get("plus")).add(project.getConfigurations().getByName(mainSourceSetConvention.getAptConfigurationName()));
                    ((Collection)((Map)ideaModule.getScopes().get("TEST")).get("plus")).add(project.getConfigurations().getByName(testSourceSetConvention.getAptConfigurationName()));
                } else {
                    ((Collection)((Map)ideaModule.getScopes().get("COMPILE")).get("plus")).addAll(Arrays.asList(project.getConfigurations().getByName(mainSourceSetConvention.getCompileOnlyConfigurationName()), project.getConfigurations().getByName(mainSourceSetConvention.getAptConfigurationName())));
                    ((Collection)((Map)ideaModule.getScopes().get("TEST")).get("plus")).addAll(Arrays.asList(project.getConfigurations().getByName(testSourceSetConvention.getCompileOnlyConfigurationName()), project.getConfigurations().getByName(testSourceSetConvention.getAptConfigurationName())));
                }
            }

            private Set<File> addToSet(Set<File> sourceDirs, File ... dirs) {
                LinkedHashSet<File> newSet = new LinkedHashSet<File>(sourceDirs);
                newSet.addAll(Arrays.asList(dirs));
                return newSet;
            }
        });
    }

    private void configureIdeaProject(final Project project) {
        if (project.getParent() == null) {
            IdeaProject ideaProject = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getProject();
            ideaProject.getIpr().withXml((Closure)new MethodClosure((Object)new Action<XmlProvider>(){

                public void execute(XmlProvider xmlProvider) {
                    for (Object it : (NodeList)xmlProvider.asNode().get("component")) {
                        Node compilerConfiguration = (Node)it;
                        if (!Objects.equals(compilerConfiguration.attribute((Object)"name"), "CompilerConfiguration")) continue;
                        for (Object n : (NodeList)compilerConfiguration.get("annotationProcessing")) {
                            compilerConfiguration.remove((Node)n);
                        }
                        Node annotationProcessing = compilerConfiguration.appendNode((Object)"annotationProcessing");
                        LinkedHashMap<String, Object> profileAttributes = new LinkedHashMap<String, Object>();
                        profileAttributes.put("name", "Default");
                        profileAttributes.put("enabled", true);
                        profileAttributes.put("default", true);
                        Node profile = annotationProcessing.appendNode((Object)"profile", profileAttributes);
                        profile.appendNode((Object)"sourceOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/source/apt/" + "main"));
                        profile.appendNode((Object)"sourceTestOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/source/apt/" + "test"));
                        profile.appendNode((Object)"outputRelativeToContentRoot", Collections.singletonMap("value", true));
                        profile.appendNode((Object)"processorPath", Collections.singletonMap("useClasspath", true));
                    }
                }
            }, "execute"));
        }
    }
}

