/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.plugins.ide.internal.generator.PropertiesPersistableConfigurationObject;

public class JdtApt
extends PropertiesPersistableConfigurationObject {
    private boolean aptEnabled;
    private String genSrcDir;
    private boolean reconcileEnabled;
    private Map<String, String> processorOptions = new LinkedHashMap<String, String>();

    JdtApt(PropertiesTransformer transformer) {
        super(transformer);
    }

    protected String getDefaultResourceName() {
        return "defaultJdtAptPrefs.properties";
    }

    protected void load(Properties properties) {
    }

    protected void store(Properties properties) {
        properties.setProperty("org.eclipse.jdt.apt.aptEnabled", Boolean.toString(this.isAptEnabled()));
        properties.setProperty("org.eclipse.jdt.apt.genSrcDir", this.getGenSrcDir());
        properties.setProperty("org.eclipse.jdt.apt.reconcileEnabled", Boolean.toString(this.isReconcileEnabled()));
        for (Map.Entry<String, String> option : this.getProcessorOptions().entrySet()) {
            properties.setProperty("org.eclipse.jdt.apt.processorOptions/" + option.getKey(), option.getValue() == null ? "org.eclipse.jdt.apt.NULLVALUE" : option.getValue());
        }
    }

    public boolean isAptEnabled() {
        return this.aptEnabled;
    }

    public void setAptEnabled(boolean aptEnabled) {
        this.aptEnabled = aptEnabled;
    }

    public String getGenSrcDir() {
        return this.genSrcDir;
    }

    public void setGenSrcDir(String genSrcDir) {
        this.genSrcDir = genSrcDir;
    }

    public boolean isReconcileEnabled() {
        return this.reconcileEnabled;
    }

    public void setReconcileEnabled(boolean reconcileEnabled) {
        this.reconcileEnabled = reconcileEnabled;
    }

    public Map<String, String> getProcessorOptions() {
        return this.processorOptions;
    }

    public void setProcessorOptions(Map<String, String> processorOptions) {
        this.processorOptions = processorOptions;
    }
}

