/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import net.ltgt.gradle.apt.AptPlugin;
import net.ltgt.gradle.apt.CompatibilityUtils;
import net.ltgt.gradle.apt.EclipseFactorypath;
import net.ltgt.gradle.apt.EclipseJdtApt;
import net.ltgt.gradle.apt.GenerateEclipseFactorypath;
import net.ltgt.gradle.apt.GenerateEclipseJdtApt;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.util.ConfigureUtil;

public class AptEclipsePlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
                SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
                AptEclipsePlugin.this.configureEclipse(project, mainSourceSet, testSourceSet);
            }
        });
    }

    private void configureEclipse(final Project project, final SourceSet mainSourceSet, final SourceSet testSourceSet) {
        Delete cleanTask;
        Object task;
        final EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                eclipseModel.getClasspath().getPlusConfigurations().addAll(Arrays.asList(project.getConfigurations().getByName(((AptPlugin.AptSourceSetConvention)new DslObject((Object)mainSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getCompileOnlyConfigurationName()), project.getConfigurations().getByName(((AptPlugin.AptSourceSetConvention)new DslObject((Object)testSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getCompileOnlyConfigurationName())));
            }
        });
        if (project.getTasks().findByName("eclipseJdtApt") == null) {
            task = (GenerateEclipseJdtApt)project.getTasks().create("eclipseJdtApt", GenerateEclipseJdtApt.class, (Action)new Action<GenerateEclipseJdtApt>(){

                public void execute(GenerateEclipseJdtApt generateEclipseJdtApt) {
                    generateEclipseJdtApt.setDescription("Generates the Eclipse JDT APT settings file.");
                    generateEclipseJdtApt.setInputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
                    generateEclipseJdtApt.setOutputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
                    final EclipseJdtApt jdtApt = generateEclipseJdtApt.getJdtApt();
                    new DslObject((Object)eclipseModel.getJdt()).getConvention().getPlugins().put("net.ltgt.apt-eclipse", new JdtAptConvention(jdtApt));
                    ConventionMapping conventionMapping = new DslObject((Object)jdtApt).getConventionMapping();
                    conventionMapping.map("aptEnabled", (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return ((AptPlugin.AptConvention)((Task)project.getTasks().findByName(mainSourceSet.getCompileJavaTaskName())).getConvention().getPlugin(AptPlugin.AptConvention.class)).getAptOptions().isAnnotationProcessing();
                        }
                    });
                    conventionMapping.map("genSrcDir", (Callable)new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            return project.file((Object)".apt_generated");
                        }
                    });
                    conventionMapping.map("processorOptions", new Callable<Map<String, ?>>(){

                        @Override
                        public Map<String, ?> call() throws Exception {
                            return ((AptPlugin.AptConvention)((Task)project.getTasks().findByName(mainSourceSet.getCompileJavaTaskName())).getConvention().getPlugin(AptPlugin.AptConvention.class)).getAptOptions().getProcessorArgs();
                        }
                    });
                    eclipseModel.getJdt().getFile().withProperties((Closure)new MethodClosure((Object)new Action<Properties>(){

                        public void execute(Properties properties) {
                            properties.setProperty("org.eclipse.jdt.core.compiler.processAnnotations", jdtApt.isAptEnabled() ? "enabled" : "disabled");
                        }
                    }, "execute"));
                }
            });
            project.getTasks().getByName("eclipse").dependsOn(new Object[]{task});
            cleanTask = (Delete)project.getTasks().create("cleanEclipseJdtApt", Delete.class);
            cleanTask.delete(new Object[]{CompatibilityUtils.getOutputs((Task)task)});
            project.getTasks().getByName("cleanEclipse").dependsOn(new Object[]{cleanTask});
        }
        if (project.getTasks().findByName("eclipseFactorypath") == null) {
            task = (GenerateEclipseFactorypath)project.getTasks().create("eclipseFactorypath", GenerateEclipseFactorypath.class, (Action)new Action<GenerateEclipseFactorypath>(){

                public void execute(GenerateEclipseFactorypath generateEclipseFactorypath) {
                    generateEclipseFactorypath.setDescription("Generates the Eclipse factorypath file.");
                    generateEclipseFactorypath.setInputFile(project.file((Object)".factorypath"));
                    generateEclipseFactorypath.setOutputFile(project.file((Object)".factorypath"));
                    EclipseFactorypath factorypath = generateEclipseFactorypath.getFactorypath();
                    new DslObject((Object)eclipseModel).getConvention().getPlugins().put("net.ltgt.apt-eclipse", new FactorypathConvention(factorypath));
                    factorypath.setPlusConfigurations(new ArrayList<Configuration>(Arrays.asList(project.getConfigurations().getByName(((AptPlugin.AptSourceSetConvention)new DslObject((Object)mainSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getAnnotationProcessorConfigurationName()), project.getConfigurations().getByName(((AptPlugin.AptSourceSetConvention)new DslObject((Object)testSourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getAnnotationProcessorConfigurationName()))));
                    generateEclipseFactorypath.dependsOn(factorypath.getPlusConfigurations().toArray());
                }
            });
            project.getTasks().getByName("eclipse").dependsOn(new Object[]{task});
            cleanTask = (Delete)project.getTasks().create("cleanEclipseFactorypath", Delete.class);
            cleanTask.delete(new Object[]{CompatibilityUtils.getOutputs((Task)task)});
            project.getTasks().getByName("cleanEclipse").dependsOn(new Object[]{cleanTask});
        }
    }

    public static class FactorypathConvention {
        private final EclipseFactorypath factorypath;

        public FactorypathConvention(EclipseFactorypath factorypath) {
            this.factorypath = factorypath;
        }

        public EclipseFactorypath getFactorypath() {
            return this.factorypath;
        }

        public void factorypath(Closure<? super EclipseFactorypath> closure) {
            ConfigureUtil.configure(closure, (Object)this.factorypath);
        }

        public void factorypath(Action<? super EclipseFactorypath> action) {
            action.execute((Object)this.factorypath);
        }
    }

    public static class JdtAptConvention {
        private final EclipseJdtApt apt;

        public JdtAptConvention(EclipseJdtApt apt) {
            this.apt = apt;
        }

        public EclipseJdtApt getApt() {
            return this.apt;
        }

        public void apt(Closure<? super EclipseJdtApt> closure) {
            ConfigureUtil.configure(closure, (Object)this.apt);
        }

        public void apt(Action<? super EclipseJdtApt> action) {
            action.execute((Object)this.apt);
        }
    }
}

