/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.ltgt.gradle.apt.AptPlugin;
import net.ltgt.gradle.apt.AptPlugin30to33;
import net.ltgt.gradle.apt.CompatibilityUtils;
import net.ltgt.gradle.apt.DeprecationLogger;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;

class AptPlugin34to42
extends AptPlugin.Impl {
    static final String APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE = "The aptOptions.processorpath property has been deprecated on JavaCompile tasks. Please use the options.annotationProcessorPath property instead.";
    final AptPlugin.Impl prevImpl = new AptPlugin30to33();

    AptPlugin34to42() {
    }

    @Override
    protected AptPlugin.AptConvention createAptConvention(Project project, AbstractCompile task, CompileOptions compileOptions) {
        if (!(task instanceof JavaCompile)) {
            return this.prevImpl.createAptConvention(project, task, compileOptions);
        }
        return new AptConvention34to42(project, task, compileOptions);
    }

    @Override
    protected void configureCompileTask(Project project, final AbstractCompile task, final CompileOptions compileOptions) {
        if (!(task instanceof JavaCompile)) {
            this.prevImpl.configureCompileTask(project, task, compileOptions);
            return;
        }
        CompatibilityUtils.property((TaskInputs)task.getInputs(), "aptOptions.annotationProcessing", new Callable<Object>(){

            @Override
            public Object call() {
                return ((AptConvention34to42)task.getConvention().getPlugin(AptConvention34to42.class)).getAptOptions().isAnnotationProcessing();
            }
        });
        CompatibilityUtils.optionalProperty((TaskInputs)task.getInputs(), "aptOptions.processors", new Callable<Object>(){

            @Override
            public Object call() {
                return ((AptConvention34to42)task.getConvention().getPlugin(AptConvention34to42.class)).getAptOptions().getProcessors();
            }
        });
        CompatibilityUtils.optionalProperty((TaskInputs)task.getInputs(), "aptOptions.processorArgs", new Callable<Object>(){

            @Override
            public Object call() {
                return ((AptConvention34to42)task.getConvention().getPlugin(AptConvention34to42.class)).getAptOptions().getProcessorArgs();
            }
        });
        task.getOutputs().dir((Object)new Callable<Object>(){

            @Override
            public Object call() {
                return ((AptPlugin.AptConvention)task.getConvention().getPlugin(AptPlugin.AptConvention.class)).getGeneratedSourcesDestinationDir();
            }
        }).withPropertyName("generatedSourcesDestinationDir").optional();
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                AptConvention34to42 convention = (AptConvention34to42)task.getConvention().getPlugin(AptConvention34to42.class);
                convention.makeDirectories();
                compileOptions.getCompilerArgs().addAll(convention.asArguments());
            }
        });
    }

    @Override
    protected AptPlugin.AptSourceSetConvention createAptSourceSetConvention(Project project, SourceSet sourceSet) {
        return new AptSourceSetConvention34to42(project, sourceSet);
    }

    @Override
    protected void ensureCompileOnlyConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
    }

    @Override
    protected Configuration ensureAnnotationProcessorConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
        Configuration annotationProcessorConfiguration = (Configuration)project.getConfigurations().create(convention.getAnnotationProcessorConfigurationName());
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSet.getName() + ".");
        return annotationProcessorConfiguration;
    }

    @Override
    protected void configureCompileTaskForSourceSet(Project project, final SourceSet sourceSet, AbstractCompile task, CompileOptions compileOptions) {
        if (!(task instanceof JavaCompile)) {
            this.prevImpl.configureCompileTaskForSourceSet(project, sourceSet, task, compileOptions);
            return;
        }
        compileOptions.setAnnotationProcessorPath((FileCollection)project.files(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return ((AptPlugin.AptSourceSetConvention)new DslObject((Object)sourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getAnnotationProcessorPath();
            }
        }}));
        ((AptPlugin.AptConvention)task.getConvention().getPlugin(AptPlugin.AptConvention.class)).setGeneratedSourcesDestinationDir(new Callable<File>(){

            @Override
            public File call() {
                return ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
            }
        });
    }

    private static class AptOptions34to42
    extends AptPlugin.AptOptions {
        private final Project project;
        private final AbstractCompile task;
        private final CompileOptions compileOptions;

        private AptOptions34to42(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.task = task;
            this.compileOptions = compileOptions;
        }

        @Override
        @Nullable
        public FileCollection getProcessorpath() {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin34to42.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            return this.compileOptions.getAnnotationProcessorPath();
        }

        @Override
        public void setProcessorpath(@Nullable Object processorpath) {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin34to42.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            if (processorpath == null || processorpath instanceof FileCollection) {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)processorpath);
            } else {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)this.project.files(new Object[]{processorpath}));
            }
        }
    }

    private static class AptConvention34to42
    extends AptPlugin.AptConvention {
        private final Project project;
        private final AptOptions34to42 aptOptions;
        private Object generatedSourcesDestinationDir;

        AptConvention34to42(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.aptOptions = new AptOptions34to42(project, task, compileOptions);
        }

        @Override
        @Nullable
        public File getGeneratedSourcesDestinationDir() {
            if (this.generatedSourcesDestinationDir == null) {
                return null;
            }
            return this.project.file(this.generatedSourcesDestinationDir);
        }

        @Override
        public void setGeneratedSourcesDestinationDir(@Nullable Object generatedSourcesDestinationDir) {
            this.generatedSourcesDestinationDir = generatedSourcesDestinationDir;
        }

        @Override
        public AptPlugin.AptOptions getAptOptions() {
            return this.aptOptions;
        }

        void makeDirectories() {
            if (this.generatedSourcesDestinationDir != null) {
                this.project.mkdir(this.generatedSourcesDestinationDir);
            }
        }

        List<String> asArguments() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.generatedSourcesDestinationDir != null) {
                result.add("-s");
                result.add(this.getGeneratedSourcesDestinationDir().getPath());
            }
            result.addAll(this.aptOptions.asArguments());
            return result;
        }
    }

    private static class AptSourceSetConvention34to42
    extends AptPlugin.AptSourceSetConvention {
        private FileCollection annotationProcessorPath;

        private AptSourceSetConvention34to42(Project project, SourceSet sourceSet) {
            super(project, sourceSet);
        }

        @Override
        @Nullable
        public FileCollection getAnnotationProcessorPath() {
            return this.annotationProcessorPath;
        }

        @Override
        public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
            this.annotationProcessorPath = annotationProcessorPath;
        }

        @Override
        public String getCompileOnlyConfigurationName() {
            return this.sourceSet.getCompileOnlyConfigurationName();
        }

        @Override
        public String getAnnotationProcessorConfigurationName() {
            return this.sourceSet.getTaskName("", "annotationProcessor");
        }
    }
}

