/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.ltgt.gradle.apt.AptPlugin;
import net.ltgt.gradle.apt.DeprecationLogger;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.CompilerArgumentProvider;

class AptPlugin45
extends AptPlugin.Impl {
    static final String GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE = "The generatedSourcesDestinationDir property has been deprecated. Please use the options.annotationProcessorGeneratedSourcesDirectory property instead.";
    static final String APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE = "The aptOptions.processorpath property has been deprecated. Please use the options.annotationProcessorPath property instead.";

    AptPlugin45() {
    }

    @Override
    protected AptPlugin.AptConvention createAptConvention(Project project, AbstractCompile task, CompileOptions compileOptions) {
        return new AptConvention45(project, task, compileOptions);
    }

    @Override
    protected void configureCompileTask(Project project, AbstractCompile task, CompileOptions compileOptions) {
        compileOptions.getCompilerArgumentProviders().add(((AptConvention45)task.getConvention().getPlugin(AptConvention45.class)).getAptOptions());
    }

    @Override
    protected AptPlugin.AptSourceSetConvention createAptSourceSetConvention(Project project, SourceSet sourceSet) {
        return new AptSourceSetConvention45(project, sourceSet);
    }

    @Override
    protected void ensureCompileOnlyConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
    }

    @Override
    protected Configuration ensureAnnotationProcessorConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
        Configuration annotationProcessorConfiguration = (Configuration)project.getConfigurations().create(convention.getAnnotationProcessorConfigurationName());
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSet.getName() + ".");
        return annotationProcessorConfiguration;
    }

    @Override
    protected void configureCompileTaskForSourceSet(Project project, final SourceSet sourceSet, AbstractCompile task, CompileOptions compileOptions) {
        if (compileOptions.getAnnotationProcessorPath() == null) {
            compileOptions.setAnnotationProcessorPath((FileCollection)project.files(new Object[]{new Callable<FileCollection>(){

                @Override
                public FileCollection call() {
                    return ((AptPlugin.AptSourceSetConvention)new DslObject((Object)sourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getAnnotationProcessorPath();
                }
            }}));
        }
        compileOptions.setAnnotationProcessorGeneratedSourcesDirectory(project.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
            }
        }));
    }

    private static class AptOptions45
    extends AptPlugin.AptOptions
    implements CompilerArgumentProvider {
        private final Project project;
        private final AbstractCompile task;
        private final CompileOptions compileOptions;

        private AptOptions45(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.task = task;
            this.compileOptions = compileOptions;
        }

        @Override
        @Nullable
        @Internal
        public FileCollection getProcessorpath() {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin45.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            return this.compileOptions.getAnnotationProcessorPath();
        }

        @Override
        public void setProcessorpath(@Nullable Object processorpath) {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin45.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            if (processorpath == null || processorpath instanceof FileCollection) {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)processorpath);
            } else {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)this.project.files(new Object[]{processorpath}));
            }
        }

        @Override
        public List<String> asArguments() {
            return super.asArguments();
        }
    }

    private static class AptConvention45
    extends AptPlugin.AptConvention {
        private final Project project;
        private final AbstractCompile task;
        private final CompileOptions compileOptions;
        private final AptOptions45 aptOptions;

        AptConvention45(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.task = task;
            this.compileOptions = compileOptions;
            this.aptOptions = new AptOptions45(project, task, compileOptions);
        }

        @Override
        @Nullable
        public File getGeneratedSourcesDestinationDir() {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin45.GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE);
            return this.compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
        }

        @Override
        public void setGeneratedSourcesDestinationDir(final @Nullable Object generatedSourcesDestinationDir) {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin45.GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE);
            if (generatedSourcesDestinationDir == null) {
                this.compileOptions.setAnnotationProcessorGeneratedSourcesDirectory((File)null);
            } else {
                this.compileOptions.setAnnotationProcessorGeneratedSourcesDirectory(this.project.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return AptConvention45.this.project.file(generatedSourcesDestinationDir);
                    }
                }));
            }
        }

        @Override
        public AptOptions45 getAptOptions() {
            return this.aptOptions;
        }
    }

    private static class AptSourceSetConvention45
    extends AptPlugin.AptSourceSetConvention {
        private FileCollection annotationProcessorPath;

        private AptSourceSetConvention45(Project project, SourceSet sourceSet) {
            super(project, sourceSet);
        }

        @Override
        @Nullable
        public FileCollection getAnnotationProcessorPath() {
            return this.annotationProcessorPath;
        }

        @Override
        public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
            this.annotationProcessorPath = annotationProcessorPath;
        }

        @Override
        public String getCompileOnlyConfigurationName() {
            return this.sourceSet.getCompileOnlyConfigurationName();
        }

        @Override
        public String getAnnotationProcessorConfigurationName() {
            return this.sourceSet.getTaskName("", "annotationProcessor");
        }
    }
}

