/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import net.ltgt.gradle.apt.AptPlugin;
import net.ltgt.gradle.apt.DeprecationLogger;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.process.CommandLineArgumentProvider;

class AptPlugin46
extends AptPlugin.Impl {
    static final String GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE = "The generatedSourcesDestinationDir property has been deprecated. Please use the options.annotationProcessorGeneratedSourcesDirectory property instead.";
    static final String APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE = "The aptOptions.processorpath property has been deprecated. Please use the options.annotationProcessorPath property instead.";

    AptPlugin46() {
    }

    @Override
    protected AptPlugin.AptConvention createAptConvention(Project project, AbstractCompile task, CompileOptions compileOptions) {
        return new AptConvention46(project, task, compileOptions);
    }

    @Override
    protected void configureCompileTask(Project project, AbstractCompile task, CompileOptions compileOptions) {
        compileOptions.getCompilerArgumentProviders().add(((AptConvention46)task.getConvention().getPlugin(AptConvention46.class)).getAptOptions());
    }

    @Override
    protected AptPlugin.AptSourceSetConvention createAptSourceSetConvention(Project project, SourceSet sourceSet) {
        return new AptSourceSetConvention46(project, sourceSet);
    }

    @Override
    protected void ensureCompileOnlyConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
    }

    @Override
    protected Configuration ensureAnnotationProcessorConfiguration(Project project, SourceSet sourceSet, AptPlugin.AptSourceSetConvention convention) {
        return project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName());
    }

    @Override
    protected void configureCompileTaskForSourceSet(Project project, final SourceSet sourceSet, AbstractCompile task, CompileOptions compileOptions) {
        compileOptions.setAnnotationProcessorGeneratedSourcesDirectory(project.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return ((AptPlugin.AptSourceSetOutputConvention)new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
            }
        }));
    }

    private static class AptOptions46
    extends AptPlugin.AptOptions
    implements CommandLineArgumentProvider {
        private final Project project;
        private final AbstractCompile task;
        private final CompileOptions compileOptions;

        private AptOptions46(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.task = task;
            this.compileOptions = compileOptions;
        }

        @Override
        @Internal
        public FileCollection getProcessorpath() {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin46.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            return this.compileOptions.getAnnotationProcessorPath();
        }

        @Override
        public void setProcessorpath(Object processorpath) {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin46.APT_OPTIONS_PROCESSORPATH_DEPRECATION_MESSAGE);
            if (processorpath == null || processorpath instanceof FileCollection) {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)processorpath);
            } else {
                this.compileOptions.setAnnotationProcessorPath((FileCollection)this.project.files(new Object[]{processorpath}));
            }
        }

        @Override
        public List<String> asArguments() {
            return super.asArguments();
        }
    }

    private static class AptConvention46
    extends AptPlugin.AptConvention {
        private final Project project;
        private final AbstractCompile task;
        private final CompileOptions compileOptions;
        private final AptOptions46 aptOptions;

        AptConvention46(Project project, AbstractCompile task, CompileOptions compileOptions) {
            this.project = project;
            this.task = task;
            this.compileOptions = compileOptions;
            this.aptOptions = new AptOptions46(project, task, compileOptions);
        }

        @Override
        public File getGeneratedSourcesDestinationDir() {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin46.GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE);
            return this.compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
        }

        @Override
        public void setGeneratedSourcesDestinationDir(final Object generatedSourcesDestinationDir) {
            DeprecationLogger.nagUserWith((Task)this.task, AptPlugin46.GENERATED_SOURCES_DESTINATION_DIR_DEPRECATION_MESSAGE);
            if (generatedSourcesDestinationDir == null) {
                this.compileOptions.setAnnotationProcessorGeneratedSourcesDirectory((File)null);
            } else {
                this.compileOptions.setAnnotationProcessorGeneratedSourcesDirectory(this.project.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return AptConvention46.this.project.file(generatedSourcesDestinationDir);
                    }
                }));
            }
        }

        @Override
        public AptOptions46 getAptOptions() {
            return this.aptOptions;
        }
    }

    private static class AptSourceSetConvention46
    extends AptPlugin.AptSourceSetConvention {
        private AptSourceSetConvention46(Project project, SourceSet sourceSet) {
            super(project, sourceSet);
        }

        @Override
        public FileCollection getAnnotationProcessorPath() {
            return this.sourceSet.getAnnotationProcessorPath();
        }

        @Override
        public void setAnnotationProcessorPath(FileCollection annotationProcessorPath) {
            this.sourceSet.setAnnotationProcessorPath(annotationProcessorPath);
        }

        @Override
        public String getCompileOnlyConfigurationName() {
            return this.sourceSet.getCompileOnlyConfigurationName();
        }

        @Override
        public String getAnnotationProcessorConfigurationName() {
            return this.sourceSet.getAnnotationProcessorConfigurationName();
        }
    }
}

