/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.ltgt.gradle.apt.AptPlugin;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.util.GradleVersion;

public class AptIdeaPlugin
implements Plugin<Project> {
    private static final boolean isIdeaImport = Boolean.getBoolean("idea.active") && System.getProperty("idea.version") != null;

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void apply(final Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(IdeaPlugin.class);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
                SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
                AptIdeaPlugin.this.configureIdeaModule(project, mainSourceSet, testSourceSet);
            }
        });
        this.configureIdeaProject(project);
    }

    private void configureIdeaModule(Project project, final SourceSet mainSourceSet, final SourceSet testSourceSet) {
        final IdeaModule ideaModule = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getModule();
        final ModuleApt apt = new ModuleApt();
        ((ExtensionAware)ideaModule).getExtensions().add("apt", (Object)apt);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (apt.isAddGeneratedSourcesDirs()) {
                    LinkedHashSet<File> excl = new LinkedHashSet<File>();
                    for (SourceSet sourceSet : new SourceSet[]{mainSourceSet, testSourceSet}) {
                        File generatedSourcesDir;
                        for (File f = generatedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)((HasConvention)sourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir(); f != null && !f.equals(project.getProjectDir()); f = f.getParentFile()) {
                            excl.add(f);
                        }
                    }
                    LinkedHashSet<File> excludeDirs = new LinkedHashSet<File>(ideaModule.getExcludeDirs());
                    if (excl.contains(project.getBuildDir()) && excludeDirs.contains(project.getBuildDir())) {
                        excludeDirs.remove(project.getBuildDir());
                        File[] subdirs = project.getBuildDir().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.isDirectory();
                            }
                        });
                        if (subdirs != null) {
                            excludeDirs.addAll(Arrays.asList(subdirs));
                        }
                    }
                    excludeDirs.removeAll(excl);
                    ideaModule.setExcludeDirs(excludeDirs);
                    File mainGeneratedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)((HasConvention)mainSourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
                    File testGeneratedSourcesDir = ((AptPlugin.AptSourceSetOutputConvention)((HasConvention)testSourceSet.getOutput()).getConvention().getPlugin(AptPlugin.AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
                    ideaModule.setSourceDirs(this.addToSet(ideaModule.getSourceDirs(), mainGeneratedSourcesDir));
                    ideaModule.setTestSourceDirs(this.addToSet(ideaModule.getTestSourceDirs(), testGeneratedSourcesDir));
                    ideaModule.setGeneratedSourceDirs(this.addToSet(ideaModule.getGeneratedSourceDirs(), mainGeneratedSourcesDir, testGeneratedSourcesDir));
                }
                if (apt.isAddCompileOnlyDependencies() || apt.isAddAptDependencies()) {
                    final ArrayList<Configuration> mainConfigurations = new ArrayList<Configuration>();
                    final ArrayList<Configuration> testConfigurations = new ArrayList<Configuration>();
                    if (apt.isAddCompileOnlyDependencies()) {
                        mainConfigurations.add(project.getConfigurations().getByName(AptPlugin.IMPL.getCompileOnlyConfigurationName(mainSourceSet)));
                        testConfigurations.add(project.getConfigurations().getByName(AptPlugin.IMPL.getCompileOnlyConfigurationName(testSourceSet)));
                    }
                    if (apt.isAddAptDependencies()) {
                        mainConfigurations.add(project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(mainSourceSet)));
                        testConfigurations.add(project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(testSourceSet)));
                    }
                    this.getScope(apt.getMainDependenciesScope(), "plus").addAll(mainConfigurations);
                    this.getScope("TEST", "plus").addAll(testConfigurations);
                    project.getTasks().withType(GenerateIdeaModule.class, (Action)new Action<GenerateIdeaModule>(){

                        public void execute(GenerateIdeaModule generateIdeaModule) {
                            generateIdeaModule.dependsOn(mainConfigurations.toArray());
                            generateIdeaModule.dependsOn(testConfigurations.toArray());
                        }
                    });
                }
            }

            private Set<File> addToSet(Set<File> sourceDirs, File ... dirs) {
                LinkedHashSet<File> newSet = new LinkedHashSet<File>(sourceDirs);
                newSet.addAll(Arrays.asList(dirs));
                return newSet;
            }

            private Collection<Configuration> getScope(String scope, String plusOrMinus) {
                return (Collection)((Map)ideaModule.getScopes().get(scope)).get(plusOrMinus);
            }
        });
    }

    private void configureIdeaProject(final Project project) {
        if (project.getParent() == null) {
            IdeaProject ideaProject = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getProject();
            final ProjectAptConvention apt = new ProjectAptConvention();
            ((HasConvention)ideaProject).getConvention().getPlugins().put("net.ltgt.apt-idea", apt);
            ideaProject.getIpr().withXml((Closure)new MethodClosure((Object)new Action<XmlProvider>(){

                public void execute(XmlProvider xmlProvider) {
                    if (!apt.isConfigureAnnotationProcessing()) {
                        return;
                    }
                    for (Object it : (NodeList)xmlProvider.asNode().get("component")) {
                        Node compilerConfiguration = (Node)it;
                        if (!Objects.equals(compilerConfiguration.attribute((Object)"name"), "CompilerConfiguration")) continue;
                        for (Object n : (NodeList)compilerConfiguration.get("annotationProcessing")) {
                            compilerConfiguration.remove((Node)n);
                        }
                        Node annotationProcessing = compilerConfiguration.appendNode((Object)"annotationProcessing");
                        LinkedHashMap<String, Object> profileAttributes = new LinkedHashMap<String, Object>();
                        profileAttributes.put("name", "Default");
                        profileAttributes.put("enabled", true);
                        profileAttributes.put("default", true);
                        Node profile = annotationProcessing.appendNode((Object)"profile", profileAttributes);
                        profile.appendNode((Object)"sourceOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/source/apt/" + "main"));
                        profile.appendNode((Object)"sourceTestOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/source/apt/" + "test"));
                        profile.appendNode((Object)"outputRelativeToContentRoot", Collections.singletonMap("value", true));
                        profile.appendNode((Object)"processorPath", Collections.singletonMap("useClasspath", true));
                    }
                }
            }, "execute"));
        }
    }

    static /* synthetic */ boolean access$100() {
        return isIdeaImport;
    }

    public static class ProjectAptConvention {
        private boolean configureAnnotationProcessing = true;

        public boolean isConfigureAnnotationProcessing() {
            return this.configureAnnotationProcessing;
        }

        public void setConfigureAnnotationProcessing(boolean configureAnnotationProcessing) {
            this.configureAnnotationProcessing = configureAnnotationProcessing;
        }
    }

    public static class ModuleApt {
        private boolean addGeneratedSourcesDirs = true;
        private boolean addCompileOnlyDependencies = GradleVersion.current().compareTo(GradleVersion.version((String)"2.12")) < 0;
        private boolean addAptDependencies = true;
        private String mainDependenciesScope = AptIdeaPlugin.access$100() ? "COMPILE" : (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0 ? "PROVIDED" : "COMPILE");

        public boolean isAddGeneratedSourcesDirs() {
            return this.addGeneratedSourcesDirs;
        }

        public void setAddGeneratedSourcesDirs(boolean addGeneratedSourcesDirs) {
            this.addGeneratedSourcesDirs = addGeneratedSourcesDirs;
        }

        public boolean isAddCompileOnlyDependencies() {
            return this.addCompileOnlyDependencies;
        }

        public void setAddCompileOnlyDependencies(boolean addCompileOnlyDependencies) {
            this.addCompileOnlyDependencies = addCompileOnlyDependencies;
        }

        public boolean isAddAptDependencies() {
            return this.addAptDependencies;
        }

        public void setAddAptDependencies(boolean addAptDependencies) {
            this.addAptDependencies = addAptDependencies;
        }

        public String getMainDependenciesScope() {
            return this.mainDependenciesScope;
        }

        public void setMainDependenciesScope(String mainDependenciesScope) {
            this.mainDependenciesScope = Objects.requireNonNull(mainDependenciesScope);
        }
    }
}

