/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.ltgt.gradle.apt.AptPlugin43to44;
import net.ltgt.gradle.apt.AptPlugin45;
import net.ltgt.gradle.apt.AptPlugin46to48;
import net.ltgt.gradle.apt.AptPlugin49;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;

public class AptPlugin
implements Plugin<Project> {
    static final String PLUGIN_ID = "net.ltgt.apt";
    static final String SOURCE_SET_OUTPUT_GENERATED_SOURCES_DIRS = "generatedSourcesDirs";
    static final Impl IMPL = Impl.newInstance();

    public void apply(Project project) {
        this.configureCompileTasks(project, JavaCompile.class, JavaCompile::getOptions);
        this.configureCompileTasks(project, GroovyCompile.class, GroovyCompile::getOptions);
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            javaConvention.getSourceSets().all(sourceSet -> {
                this.configureSourceSet(project, (SourceSet)sourceSet);
                this.configureCompileTaskForSourceSet(project, (SourceSet)sourceSet, sourceSet.getJava(), sourceSet.getCompileJavaTaskName(), (Class)JavaCompile.class, JavaCompile::getOptions);
            });
        });
        project.getPlugins().withType(GroovyBasePlugin.class, groovyBasePlugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            javaConvention.getSourceSets().all(sourceSet -> {
                SourceDirectorySet groovy = ((GroovySourceSet)((HasConvention)sourceSet).getConvention().getPlugin(GroovySourceSet.class)).getGroovy();
                this.configureCompileTaskForSourceSet(project, (SourceSet)sourceSet, groovy, sourceSet.getCompileTaskName("groovy"), (Class)GroovyCompile.class, GroovyCompile::getOptions);
            });
        });
    }

    private <T extends AbstractCompile> void configureCompileTasks(Project project, Class<T> compileTaskClass, Function<T, CompileOptions> getCompileOptions) {
        IMPL.configureTasks(project, compileTaskClass, task -> {
            CompileOptions compileOptions = (CompileOptions)getCompileOptions.apply(task);
            AptOptions aptOptions = IMPL.createAptOptions();
            task.getExtensions().add(AptOptions.class, "aptOptions", (Object)aptOptions);
            IMPL.configureCompileTask((AbstractCompile)task, compileOptions, aptOptions);
        });
    }

    private <T extends AbstractCompile> void configureCompileTaskForSourceSet(Project project, SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, String compileTaskName, Class<T> compileTaskClass, Function<T, CompileOptions> getCompileOptions) {
        Object taskOrProvider = IMPL.configureTask(project, compileTaskClass, compileTaskName, task -> {
            CompileOptions compileOptions = (CompileOptions)getCompileOptions.apply(task);
            IMPL.configureCompileTaskForSourceSet(project, sourceSet, compileOptions);
            compileOptions.setAnnotationProcessorGeneratedSourcesDirectory(project.provider(() -> new File(project.getBuildDir(), "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName())));
        });
        ((ExtensionAware)sourceSet.getOutput()).getExtensions().configure(SOURCE_SET_OUTPUT_GENERATED_SOURCES_DIRS, files -> files.from(new Object[]{() -> ((CompileOptions)getCompileOptions.apply((AbstractCompile)project.getTasks().withType(compileTaskClass).getByName(compileTaskName))).getAnnotationProcessorGeneratedSourcesDirectory()}).builtBy(new Object[]{taskOrProvider}));
    }

    private void configureSourceSet(Project project, SourceSet sourceSet) {
        IMPL.ensureConfigurations(project, sourceSet);
        ConfigurableFileCollection files = project.files(new Object[0]);
        ((ExtensionAware)sourceSet.getOutput()).getExtensions().add(FileCollection.class, SOURCE_SET_OUTPUT_GENERATED_SOURCES_DIRS, (Object)files);
    }

    public static final class AptSourceSetConvention {
        protected final Project project;
        protected final SourceSet sourceSet;
        @Nullable
        private FileCollection annotationProcessorPath;

        AptSourceSetConvention(Project project, SourceSet sourceSet, Configuration annotationProcessorPath) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.annotationProcessorPath = annotationProcessorPath;
        }

        @Nullable
        public FileCollection getAnnotationProcessorPath() {
            return this.annotationProcessorPath;
        }

        public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
            this.annotationProcessorPath = annotationProcessorPath;
        }

        public String getAnnotationProcessorConfigurationName() {
            return IMPL.getAnnotationProcessorConfigurationName(this.sourceSet);
        }
    }

    public static class AptOptions
    implements HasPublicType {
        private boolean annotationProcessing = true;
        @Nullable
        private List<?> processors = new ArrayList();
        @Nullable
        private Map<String, ?> processorArgs = new LinkedHashMap();

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(AptOptions.class);
        }

        @Input
        public boolean isAnnotationProcessing() {
            return this.annotationProcessing;
        }

        public void setAnnotationProcessing(boolean annotationProcessing) {
            this.annotationProcessing = annotationProcessing;
        }

        @Input
        @Optional
        @Nullable
        public List<?> getProcessors() {
            return this.processors;
        }

        public void setProcessors(@Nullable List<?> processors) {
            this.processors = processors;
        }

        @Input
        @Optional
        @Nullable
        public Map<String, ?> getProcessorArgs() {
            return this.processorArgs;
        }

        public void setProcessorArgs(@Nullable Map<String, ?> processorArgs) {
            this.processorArgs = processorArgs;
        }

        protected List<String> asArguments() {
            ArrayList<String> arguments = new ArrayList<String>();
            if (!this.annotationProcessing) {
                arguments.add("-proc:none");
            }
            if (this.processors != null && !this.processors.isEmpty()) {
                arguments.add("-processor");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object processor : this.processors) {
                    if (!first) {
                        sb.append(',');
                    } else {
                        first = false;
                    }
                    sb.append(processor);
                }
                arguments.add(sb.toString());
            }
            if (this.processorArgs != null) {
                for (Map.Entry<String, ?> entry : this.processorArgs.entrySet()) {
                    arguments.add("-A" + entry.getKey() + "=" + entry.getValue());
                }
            }
            return arguments;
        }
    }

    static abstract class Impl {
        Impl() {
        }

        static Impl newInstance() {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.9")) >= 0) {
                return new AptPlugin49();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.6")) >= 0) {
                return new AptPlugin46to48();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.5")) >= 0) {
                return new AptPlugin45();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.3")) >= 0) {
                return new AptPlugin43to44();
            }
            throw new UnsupportedOperationException();
        }

        protected abstract <T extends Task> Object createTask(Project var1, String var2, Class<T> var3, Action<T> var4);

        protected abstract <T extends Task> void configureTasks(Project var1, Class<T> var2, Action<T> var3);

        protected abstract <T extends Task> Object configureTask(Project var1, Class<T> var2, String var3, Action<T> var4);

        protected abstract AptOptions createAptOptions();

        protected abstract void configureCompileTask(AbstractCompile var1, CompileOptions var2, AptOptions var3);

        abstract void ensureConfigurations(Project var1, SourceSet var2);

        protected abstract void configureCompileTaskForSourceSet(Project var1, SourceSet var2, CompileOptions var3);

        abstract String getAnnotationProcessorConfigurationName(SourceSet var1);
    }
}

