/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.pluginyml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecrell.pluginyml.LibrariesKt;
import net.minecrell.pluginyml.PluginDescription;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Namer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lnet/minecrell/pluginyml/GeneratePluginDescription;", "Lorg/gradle/api/DefaultTask;", "()V", "fileName", "Lorg/gradle/api/provider/Property;", "", "getFileName", "()Lorg/gradle/api/provider/Property;", "librariesJsonFileName", "getLibrariesJsonFileName", "librariesRootComponent", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getLibrariesRootComponent", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginDescription", "Lnet/minecrell/pluginyml/PluginDescription;", "getPluginDescription", "generate", "", "NamedDomainObjectCollectionConverter", "PluginLibraries", "UrlArtifactRepositoryConverter", "plugin-yml"})
public abstract class GeneratePluginDescription
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<String> getFileName();

    @Input
    @NotNull
    public abstract Property<String> getLibrariesJsonFileName();

    @Input
    @Optional
    @NotNull
    public abstract Property<ResolvedComponentResult> getLibrariesRootComponent();

    @Nested
    @NotNull
    public abstract Property<PluginDescription> getPluginDescription();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public final void generate() {
        YAMLFactory factory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
        SimpleModule module = new SimpleModule();
        NamedDomainObjectCollectionConverter namedDomainObjectCollectionConverter = NamedDomainObjectCollectionConverter.INSTANCE;
        Intrinsics.checkNotNull((Object)((Object)namedDomainObjectCollectionConverter), (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.util.Converter<org.gradle.api.NamedDomainObjectCollection<*>, *>");
        module.addSerializer((JsonSerializer)new StdDelegatingSerializer(NamedDomainObjectCollection.class, (Converter)namedDomainObjectCollectionConverter));
        module.addSerializer((JsonSerializer)new StdDelegatingSerializer(UrlArtifactRepository.class, (Converter)UrlArtifactRepositoryConverter.INSTANCE));
        ObjectMapper mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)factory)).registerModule((Module)module).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        Object object = this.getPluginDescription().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginDescription.get()");
        PluginDescription pluginDescription = (PluginDescription)object;
        mapper.writeValue(((RegularFile)this.getOutputDirectory().file((Provider)this.getFileName()).get()).getAsFile(), (Object)pluginDescription);
        if (pluginDescription.getGenerateLibrariesJson()) {
            NamedDomainObjectList namedDomainObjectList = this.getProject().getRepositories().withType(MavenArtifactRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectList, (String)"this.project.repositorie\u2026ctRepository::class.java)");
            NamedDomainObjectList repos = namedDomainObjectList;
            List dependencies = LibrariesKt.collectLibraries$default((ResolvedComponentResult)this.getLibrariesRootComponent().getOrNull(), null, 1, null);
            PluginLibraries pluginLibraries = new PluginLibraries((NamedDomainObjectCollection<MavenArtifactRepository>)((NamedDomainObjectCollection)repos), dependencies);
            ObjectMapper jsonMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).registerModule((Module)module).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            jsonMapper.writeValue(((RegularFile)this.getOutputDirectory().file((Provider)this.getLibrariesJsonFileName()).get()).getAsFile(), (Object)pluginLibraries);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\t"}, d2={"Lnet/minecrell/pluginyml/GeneratePluginDescription$NamedDomainObjectCollectionConverter;", "Lcom/fasterxml/jackson/databind/util/StdConverter;", "Lorg/gradle/api/NamedDomainObjectCollection;", "", "", "", "()V", "convert", "value", "plugin-yml"})
    @SourceDebugExtension(value={"SMAP\nGeneratePluginDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratePluginDescription.kt\nnet/minecrell/pluginyml/GeneratePluginDescription$NamedDomainObjectCollectionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1194#2,2:119\n1222#2,4:121\n*S KotlinDebug\n*F\n+ 1 GeneratePluginDescription.kt\nnet/minecrell/pluginyml/GeneratePluginDescription$NamedDomainObjectCollectionConverter\n*L\n104#1:119,2\n104#1:121,4\n*E\n"})
    public static final class NamedDomainObjectCollectionConverter
    extends StdConverter<NamedDomainObjectCollection<Object>, Map<String, ? extends Object>> {
        @NotNull
        public static final NamedDomainObjectCollectionConverter INSTANCE = new NamedDomainObjectCollectionConverter();

        private NamedDomainObjectCollectionConverter() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Map<String, Object> convert(@NotNull NamedDomainObjectCollection<Object> value) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Namer namer = value.getNamer();
            Intrinsics.checkNotNullExpressionValue((Object)namer, (String)"value.namer");
            Namer namer2 = namer;
            Iterable $this$associateBy$iv = (Iterable)value;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator = $this$associateByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv;
                Object t = element$iv$iv = iterator.next();
                Map map = destination$iv$iv;
                boolean bl = false;
                String string = namer2.determineName((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namer.determineName(it)");
                map.put(string, element$iv$iv);
            }
            return destination$iv$iv;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/minecrell/pluginyml/GeneratePluginDescription$PluginLibraries;", "", "repositories", "Lorg/gradle/api/NamedDomainObjectCollection;", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "dependencies", "", "", "(Lorg/gradle/api/NamedDomainObjectCollection;Ljava/util/List;)V", "getDependencies", "()Ljava/util/List;", "getRepositories", "()Lorg/gradle/api/NamedDomainObjectCollection;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "plugin-yml"})
    public static final class PluginLibraries {
        @NotNull
        private final NamedDomainObjectCollection<MavenArtifactRepository> repositories;
        @NotNull
        private final List<String> dependencies;

        public PluginLibraries(@NotNull NamedDomainObjectCollection<MavenArtifactRepository> repositories, @NotNull List<String> dependencies) {
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.repositories = repositories;
            this.dependencies = dependencies;
        }

        @NotNull
        public final NamedDomainObjectCollection<MavenArtifactRepository> getRepositories() {
            return this.repositories;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final NamedDomainObjectCollection<MavenArtifactRepository> component1() {
            return this.repositories;
        }

        @NotNull
        public final List<String> component2() {
            return this.dependencies;
        }

        @NotNull
        public final PluginLibraries copy(@NotNull NamedDomainObjectCollection<MavenArtifactRepository> repositories, @NotNull List<String> dependencies) {
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new PluginLibraries(repositories, dependencies);
        }

        public static /* synthetic */ PluginLibraries copy$default(PluginLibraries pluginLibraries, NamedDomainObjectCollection namedDomainObjectCollection, List list, int n, Object object) {
            if ((n & 1) != 0) {
                namedDomainObjectCollection = pluginLibraries.repositories;
            }
            if ((n & 2) != 0) {
                list = pluginLibraries.dependencies;
            }
            return pluginLibraries.copy(namedDomainObjectCollection, list);
        }

        @NotNull
        public String toString() {
            return "PluginLibraries(repositories=" + this.repositories + ", dependencies=" + this.dependencies + ')';
        }

        public int hashCode() {
            int result = this.repositories.hashCode();
            result = result * 31 + ((Object)this.dependencies).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginLibraries)) {
                return false;
            }
            PluginLibraries pluginLibraries = (PluginLibraries)other;
            if (!Intrinsics.areEqual(this.repositories, pluginLibraries.repositories)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependencies, pluginLibraries.dependencies);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/minecrell/pluginyml/GeneratePluginDescription$UrlArtifactRepositoryConverter;", "Lcom/fasterxml/jackson/databind/util/StdConverter;", "Lorg/gradle/api/artifacts/repositories/UrlArtifactRepository;", "", "()V", "convert", "value", "plugin-yml"})
    public static final class UrlArtifactRepositoryConverter
    extends StdConverter<UrlArtifactRepository, String> {
        @NotNull
        public static final UrlArtifactRepositoryConverter INSTANCE = new UrlArtifactRepositoryConverter();

        private UrlArtifactRepositoryConverter() {
        }

        @NotNull
        public String convert(@NotNull UrlArtifactRepository value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value.getUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.url.toString()");
            return string;
        }
    }
}

