/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.pluginyml.bukkit;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecrell.pluginyml.InvalidPluginDescriptionException;
import net.minecrell.pluginyml.LibrariesKt;
import net.minecrell.pluginyml.PlatformPlugin;
import net.minecrell.pluginyml.bukkit.BukkitPluginDescription;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u001a\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\u000f"}, d2={"Lnet/minecrell/pluginyml/bukkit/BukkitPlugin;", "Lnet/minecrell/pluginyml/PlatformPlugin;", "Lnet/minecrell/pluginyml/bukkit/BukkitPluginDescription;", "()V", "createExtension", "project", "Lorg/gradle/api/Project;", "setDefaults", "", "description", "setLibraries", "libraries", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "validate", "Companion", "plugin-yml"})
@SourceDebugExtension(value={"SMAP\nBukkitPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitPlugin.kt\nnet/minecrell/pluginyml/bukkit/BukkitPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n1726#2,3:79\n*S KotlinDebug\n*F\n+ 1 BukkitPlugin.kt\nnet/minecrell/pluginyml/bukkit/BukkitPlugin\n*L\n65#1:77,2\n70#1:79,3\n*E\n"})
public final class BukkitPlugin
extends PlatformPlugin<BukkitPluginDescription> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex VALID_NAME = new Regex("^[A-Za-z0-9 _.-]+$");

    public BukkitPlugin() {
        super("Bukkit", "plugin.yml");
    }

    @Override
    @NotNull
    protected BukkitPluginDescription createExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new BukkitPluginDescription(project);
    }

    @Override
    protected void setDefaults(@NotNull Project project, @NotNull BukkitPluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            string = project.getName();
        }
        description.setName(string);
        String string2 = description.getVersion();
        if (string2 == null) {
            string2 = project.getVersion().toString();
        }
        description.setVersion(string2);
        String string3 = description.getDescription();
        if (string3 == null) {
            string3 = project.getDescription();
        }
        description.setDescription(string3);
        String string4 = description.getWebsite();
        if (string4 == null) {
            Object object = project.findProperty("url");
            string4 = object != null ? object.toString() : null;
        }
        description.setWebsite(string4);
        String string5 = description.getAuthor();
        if (string5 == null) {
            Object object = project.findProperty("author");
            string5 = object != null ? object.toString() : null;
        }
        description.setAuthor(string5);
    }

    @Override
    protected void setLibraries(@Nullable ResolvedComponentResult libraries, @NotNull BukkitPluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        description.setLibraries(LibrariesKt.collectLibraries(libraries, description.getLibraries()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(@NotNull BukkitPluginDescription description) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            throw new InvalidPluginDescriptionException("Plugin name is not set");
        }
        String name = string;
        if (!VALID_NAME.matches((CharSequence)name)) {
            throw new InvalidPluginDescriptionException("Invalid plugin name: should match " + VALID_NAME);
        }
        CharSequence charSequence = description.getVersion();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Plugin version is not set");
        }
        String string2 = description.getMain();
        if (string2 == null) {
            throw new InvalidPluginDescriptionException("Main class is not defined");
        }
        String main = string2;
        if (((CharSequence)main).length() == 0) {
            throw new InvalidPluginDescriptionException("Main class cannot be empty");
        }
        if (StringsKt.startsWith$default((String)main, (String)"org.bukkit.", (boolean)false, (int)2, null)) {
            throw new InvalidPluginDescriptionException("Main may not be within the org.bukkit namespace");
        }
        for (Object command : description.getCommands()) {
            if (StringsKt.contains$default((CharSequence)((BukkitPluginDescription.Command)command).getName(), (char)':', (boolean)false, (int)2, null)) {
                throw new InvalidPluginDescriptionException("Command '" + ((BukkitPluginDescription.Command)command).getName() + "' cannot contain ':'");
            }
            List<String> list = ((BukkitPluginDescription.Command)command).getAliases();
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String alias = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)alias, (char)':', (boolean)false, (int)2, null)) continue;
                throw new InvalidPluginDescriptionException("Alias '" + alias + "' of '" + ((BukkitPluginDescription.Command)command).getName() + "' cannot contain ':'");
            }
        }
        List<String> list = description.getProvides();
        if (list != null) {
            boolean bl3;
            block15: {
                void $this$all$iv;
                Object command;
                command = list;
                Regex regex = VALID_NAME;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CharSequence p0 = (CharSequence)element$iv;
                        boolean bl4 = false;
                        if (regex.matches(p0)) continue;
                        bl3 = false;
                        break block15;
                    }
                    bl3 = true;
                }
            }
            bl = !bl3;
        } else {
            bl = false;
        }
        if (bl) {
            throw new InvalidPluginDescriptionException("Invalid plugin provides name: all should match " + VALID_NAME);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lnet/minecrell/pluginyml/bukkit/BukkitPlugin$Companion;", "", "()V", "VALID_NAME", "Lkotlin/text/Regex;", "getVALID_NAME$annotations", "plugin-yml"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getVALID_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

