/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.pluginyml.bungee;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecrell.pluginyml.InvalidPluginDescriptionException;
import net.minecrell.pluginyml.LibrariesKt;
import net.minecrell.pluginyml.PlatformPlugin;
import net.minecrell.pluginyml.bungee.BungeePluginDescription;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u001a\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lnet/minecrell/pluginyml/bungee/BungeePlugin;", "Lnet/minecrell/pluginyml/PlatformPlugin;", "Lnet/minecrell/pluginyml/bungee/BungeePluginDescription;", "()V", "createExtension", "project", "Lorg/gradle/api/Project;", "setDefaults", "", "description", "setLibraries", "libraries", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "validate", "plugin-yml"})
public final class BungeePlugin
extends PlatformPlugin<BungeePluginDescription> {
    public BungeePlugin() {
        super("Bungee", "bungee.yml");
    }

    @Override
    @NotNull
    protected BungeePluginDescription createExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new BungeePluginDescription();
    }

    @Override
    protected void setDefaults(@NotNull Project project, @NotNull BungeePluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            string = project.getName();
        }
        description.setName(string);
        String string2 = description.getVersion();
        if (string2 == null) {
            string2 = project.getVersion().toString();
        }
        description.setVersion(string2);
        String string3 = description.getDescription();
        if (string3 == null) {
            string3 = project.getDescription();
        }
        description.setDescription(string3);
        String string4 = description.getAuthor();
        if (string4 == null) {
            Object object = project.findProperty("author");
            string4 = object != null ? object.toString() : null;
        }
        description.setAuthor(string4);
    }

    @Override
    protected void setLibraries(@Nullable ResolvedComponentResult libraries, @NotNull BungeePluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        description.setLibraries(LibrariesKt.collectLibraries(libraries, description.getLibraries()));
    }

    @Override
    protected void validate(@NotNull BungeePluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        CharSequence charSequence = description.getName();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Plugin name is not set");
        }
        charSequence = description.getMain();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Main class is not defined");
        }
    }
}

