/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.pluginyml.nukkit;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecrell.pluginyml.InvalidPluginDescriptionException;
import net.minecrell.pluginyml.PlatformPlugin;
import net.minecrell.pluginyml.nukkit.NukkitPluginDescription;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lnet/minecrell/pluginyml/nukkit/NukkitPlugin;", "Lnet/minecrell/pluginyml/PlatformPlugin;", "Lnet/minecrell/pluginyml/nukkit/NukkitPluginDescription;", "()V", "createExtension", "project", "Lorg/gradle/api/Project;", "setDefaults", "", "description", "validate", "plugin-yml"})
@SourceDebugExtension(value={"SMAP\nNukkitPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NukkitPlugin.kt\nnet/minecrell/pluginyml/nukkit/NukkitPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1855#2,2:62\n*S KotlinDebug\n*F\n+ 1 NukkitPlugin.kt\nnet/minecrell/pluginyml/nukkit/NukkitPlugin\n*L\n54#1:62,2\n*E\n"})
public final class NukkitPlugin
extends PlatformPlugin<NukkitPluginDescription> {
    public NukkitPlugin() {
        super("Nukkit", "nukkit.yml");
    }

    @Override
    @NotNull
    protected NukkitPluginDescription createExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new NukkitPluginDescription(project);
    }

    @Override
    protected void setDefaults(@NotNull Project project, @NotNull NukkitPluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            string = project.getName();
        }
        description.setName(string);
        String string2 = description.getVersion();
        if (string2 == null) {
            string2 = project.getVersion().toString();
        }
        description.setVersion(string2);
        String string3 = description.getDescription();
        if (string3 == null) {
            string3 = project.getDescription();
        }
        description.setDescription(string3);
        String string4 = description.getWebsite();
        if (string4 == null) {
            Object object = project.findProperty("url");
            string4 = object != null ? object.toString() : null;
        }
        description.setWebsite(string4);
        String string5 = description.getAuthor();
        if (string5 == null) {
            Object object = project.findProperty("author");
            string5 = object != null ? object.toString() : null;
        }
        description.setAuthor(string5);
    }

    @Override
    protected void validate(@NotNull NukkitPluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        CharSequence charSequence = description.getName();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Plugin name is not set");
        }
        charSequence = description.getVersion();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Plugin version class is not set");
        }
        String string = description.getMain();
        if (string == null) {
            throw new InvalidPluginDescriptionException("Main class is not defined");
        }
        String main = string;
        if (((CharSequence)main).length() == 0) {
            throw new InvalidPluginDescriptionException("Main class cannot be empty");
        }
        if (StringsKt.startsWith$default((String)main, (String)"cn.nukkit.", (boolean)false, (int)2, null)) {
            throw new InvalidPluginDescriptionException("Main class cannot be within cn.nukkit. package");
        }
        Collection collection = description.getApi();
        if (collection == null || collection.isEmpty()) {
            throw new InvalidPluginDescriptionException("Nukkit API version is not set");
        }
        for (NukkitPluginDescription.Command command : description.getCommands()) {
            if (StringsKt.contains$default((CharSequence)command.getName(), (char)':', (boolean)false, (int)2, null)) {
                throw new InvalidPluginDescriptionException("Command '" + command.getName() + "' cannot contain ':'");
            }
            List<String> list = command.getAliases();
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String alias = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)alias, (char)':', (boolean)false, (int)2, null)) continue;
                throw new InvalidPluginDescriptionException("Alias '" + alias + "' of '" + command.getName() + "' cannot contain ':'");
            }
        }
    }
}

