/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.pluginyml.paper;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecrell.pluginyml.InvalidPluginDescriptionException;
import net.minecrell.pluginyml.PlatformPlugin;
import net.minecrell.pluginyml.paper.PaperPluginDescription;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lnet/minecrell/pluginyml/paper/PaperPlugin;", "Lnet/minecrell/pluginyml/PlatformPlugin;", "Lnet/minecrell/pluginyml/paper/PaperPluginDescription;", "()V", "createExtension", "project", "Lorg/gradle/api/Project;", "setDefaults", "", "description", "validate", "validateNamespace", "namespace", "", "name", "Companion", "plugin-yml"})
@SourceDebugExtension(value={"SMAP\nPaperPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaperPlugin.kt\nnet/minecrell/pluginyml/paper/PaperPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1726#2,3:88\n*S KotlinDebug\n*F\n+ 1 PaperPlugin.kt\nnet/minecrell/pluginyml/paper/PaperPlugin\n*L\n74#1:88,3\n*E\n"})
public final class PaperPlugin
extends PlatformPlugin<PaperPluginDescription> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex VALID_NAME = new Regex("^[A-Za-z0-9 _.-]+$");
    @NotNull
    private static final List<String> INVALID_NAMESPACES;

    public PaperPlugin() {
        super("Paper", "paper-plugin.yml");
    }

    @Override
    @NotNull
    protected PaperPluginDescription createExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new PaperPluginDescription(project);
    }

    @Override
    protected void setDefaults(@NotNull Project project, @NotNull PaperPluginDescription description) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            string = project.getName();
        }
        description.setName(string);
        String string2 = description.getVersion();
        if (string2 == null) {
            string2 = project.getVersion().toString();
        }
        description.setVersion(string2);
        String string3 = description.getDescription();
        if (string3 == null) {
            string3 = project.getDescription();
        }
        description.setDescription(string3);
        String string4 = description.getWebsite();
        if (string4 == null) {
            Object object = project.findProperty("url");
            string4 = object != null ? object.toString() : null;
        }
        description.setWebsite(string4);
        String string5 = description.getAuthor();
        if (string5 == null) {
            Object object = project.findProperty("author");
            string5 = object != null ? object.toString() : null;
        }
        description.setAuthor(string5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(@NotNull PaperPluginDescription description) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getName();
        if (string == null) {
            throw new InvalidPluginDescriptionException("Plugin name is not set");
        }
        String name = string;
        if (!VALID_NAME.matches((CharSequence)name)) {
            throw new InvalidPluginDescriptionException("Invalid plugin name: should match " + VALID_NAME);
        }
        CharSequence charSequence = description.getVersion();
        if (charSequence == null || charSequence.length() == 0) {
            throw new InvalidPluginDescriptionException("Plugin version is not set");
        }
        if (description.getApiVersion() == null) {
            throw new InvalidPluginDescriptionException("Plugin API version is not set");
        }
        String string2 = description.getApiVersion();
        if (string2 != null) {
            String apiVersion = string2;
            boolean bl2 = false;
            if (apiVersion.compareTo("1.19") < 0) {
                throw new InvalidPluginDescriptionException("Plugin API version must be at least 1.19");
            }
        }
        String string3 = description.getMain();
        if (string3 == null) {
            throw new InvalidPluginDescriptionException("Main class is not defined");
        }
        String main = string3;
        if (((CharSequence)main).length() == 0) {
            throw new InvalidPluginDescriptionException("Main class cannot be empty");
        }
        this.validateNamespace(description.getMain(), "Main");
        this.validateNamespace(description.getBootstrapper(), "Bootstrapper");
        this.validateNamespace(description.getLoader(), "Loader");
        for (PaperPluginDescription.DependencyDefinition serverDependency : description.getServerDependencies()) {
            if (!(((CharSequence)serverDependency.getName()).length() == 0)) continue;
            throw new InvalidPluginDescriptionException("Plugin name in serverDependencies can not be empty");
        }
        for (Object bootstrapDependency : description.getBootstrapDependencies()) {
            if (!(((CharSequence)((PaperPluginDescription.DependencyDefinition)bootstrapDependency).getName()).length() == 0)) continue;
            throw new InvalidPluginDescriptionException("Plugin name in bootstrapDependencies can not be empty");
        }
        List<String> list = description.getProvides();
        if (list != null) {
            boolean bl3;
            block16: {
                void $this$all$iv;
                Object bootstrapDependency;
                bootstrapDependency = list;
                Regex regex = VALID_NAME;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CharSequence p0 = (CharSequence)element$iv;
                        boolean bl4 = false;
                        if (regex.matches(p0)) continue;
                        bl3 = false;
                        break block16;
                    }
                    bl3 = true;
                }
            }
            bl = !bl3;
        } else {
            bl = false;
        }
        if (bl) {
            throw new InvalidPluginDescriptionException("Invalid plugin provides name: all should match " + VALID_NAME);
        }
    }

    private final void validateNamespace(String namespace, String name) {
        for (String invalidNamespace : INVALID_NAMESPACES) {
            String string = namespace;
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)invalidNamespace, (boolean)false, (int)2, null) : false;
            if (!bl) continue;
            throw new InvalidPluginDescriptionException(name + " may not be within the " + invalidNamespace + " namespace");
        }
    }

    static {
        Object[] objectArray = new String[]{"net.minecraft.", "org.bukkit.", "io.papermc.paper.", "com.destroystokoyo.paper."};
        INVALID_NAMESPACES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\n"}, d2={"Lnet/minecrell/pluginyml/paper/PaperPlugin$Companion;", "", "()V", "INVALID_NAMESPACES", "", "", "getINVALID_NAMESPACES$annotations", "VALID_NAME", "Lkotlin/text/Regex;", "getVALID_NAME$annotations", "plugin-yml"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getVALID_NAME$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getINVALID_NAMESPACES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

