/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution;

import java.util.LinkedList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.execution.Execution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;

public abstract class AbstractExecution
implements Execution {
    protected List<ChecksumFile> files;
    protected String subPath;
    protected List<String> algorithms;
    protected List<ExecutionTarget> targets;
    protected boolean failIfNoFiles = true;
    protected boolean failIfNoAlgorithms = true;
    protected boolean failIfNoTargets = true;

    @Override
    public List<ChecksumFile> getFiles() {
        if (this.files == null) {
            this.files = new LinkedList<ChecksumFile>();
        }
        return this.files;
    }

    @Override
    public void setFiles(List<ChecksumFile> files) {
        this.files = files;
    }

    @Override
    public String getSubPath() {
        return this.subPath;
    }

    @Override
    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    @Override
    public void addFile(ChecksumFile file) {
        this.getFiles().add(file);
    }

    @Override
    public void removeFile(ChecksumFile file) {
        if (this.files != null) {
            this.files.remove(file);
        }
    }

    @Override
    public List<String> getAlgorithms() {
        if (this.algorithms == null) {
            this.algorithms = new LinkedList<String>();
        }
        return this.algorithms;
    }

    @Override
    public void setAlgorithms(List<String> algorithms) {
        this.algorithms = algorithms;
    }

    @Override
    public void addAlgorithm(String algorithm) {
        this.getAlgorithms().add(algorithm);
    }

    @Override
    public void removeAlgorithm(String algorithm) {
        if (this.algorithms != null) {
            this.algorithms.remove(algorithm);
        }
    }

    @Override
    public List<ExecutionTarget> getTargets() {
        if (this.targets == null) {
            this.targets = new LinkedList<ExecutionTarget>();
        }
        return this.targets;
    }

    @Override
    public void addTarget(ExecutionTarget target) {
        this.getTargets().add(target);
    }

    @Override
    public void removeTarget(ExecutionTarget target) {
        if (this.targets != null) {
            this.targets.remove(target);
        }
    }

    @Override
    public void setTargets(List<ExecutionTarget> targets) {
        this.targets = targets;
    }

    @Override
    public boolean isFailIfNoFiles() {
        return this.failIfNoFiles;
    }

    @Override
    public void setFailIfNoFiles(boolean failIfNoFiles) {
        this.failIfNoFiles = failIfNoFiles;
    }

    @Override
    public boolean isFailIfNoAlgorithms() {
        return this.failIfNoAlgorithms;
    }

    @Override
    public void setFailIfNoAlgorithms(boolean failIfNoAlgorithms) {
        this.failIfNoAlgorithms = failIfNoAlgorithms;
    }

    @Override
    public boolean isFailIfNoTargets() {
        return this.failIfNoTargets;
    }

    @Override
    public void setFailIfNoTargets(boolean failIfNoTargets) {
        this.failIfNoTargets = failIfNoTargets;
    }

    @Override
    public void checkParameters() throws ExecutionException {
        if (this.isFailIfNoFiles() && (this.files == null || this.files.isEmpty())) {
            throw new ExecutionException("No file to process.");
        }
        if (this.isFailIfNoAlgorithms() && (this.algorithms == null || this.algorithms.isEmpty())) {
            throw new ExecutionException("No checksum algorithm defined.");
        }
        if (this.isFailIfNoTargets() && (this.targets == null || this.targets.isEmpty())) {
            throw new ExecutionException("No output target defined.");
        }
    }
}

