/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.mojo.AbstractChecksumMojo;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="files", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, threadSafe=true)
public class FilesMojo
extends AbstractChecksumMojo {
    public static final String NAME = "files";
    protected static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter(required=true)
    protected List<FileSet> fileSets;
    @Parameter(defaultValue="true")
    protected boolean individualFiles;
    @Parameter
    protected String individualFilesOutputDirectory;
    @Parameter(defaultValue="true")
    protected boolean csvSummary;
    @Parameter(defaultValue="checksums.csv")
    protected String csvSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean xmlSummary;
    @Parameter(defaultValue="checksums.xml")
    protected String xmlSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean shasumSummary;
    @Parameter(defaultValue="checksums.sha")
    protected String shasumSummaryFile;
    @Parameter(defaultValue="true")
    protected boolean failIfNoFiles;

    public FilesMojo() {
        super(true, true, true);
    }

    @Override
    protected List<ChecksumFile> getFilesToProcess() {
        ArrayList<ChecksumFile> filesToProcess = new ArrayList<ChecksumFile>();
        for (FileSet fileSet : this.fileSets) {
            String[] includes;
            DirectoryScanner scanner = new DirectoryScanner();
            String fileSetDirectory = new File(fileSet.getDirectory()).getPath();
            scanner.setBasedir(fileSetDirectory);
            if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty()) {
                List fileSetIncludes = fileSet.getIncludes();
                includes = fileSetIncludes.toArray(new String[fileSetIncludes.size()]);
            } else {
                includes = DEFAULT_INCLUDES;
            }
            scanner.setIncludes(includes);
            if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty()) {
                List fileSetExcludes = fileSet.getExcludes();
                scanner.setExcludes(fileSetExcludes.toArray(new String[fileSetExcludes.size()]));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String filePath : scanner.getIncludedFiles()) {
                filesToProcess.add(new ChecksumFile(new File(fileSetDirectory).getPath(), new File(fileSetDirectory, filePath)));
            }
        }
        return filesToProcess;
    }

    @Override
    protected boolean isIndividualFiles() {
        return this.individualFiles;
    }

    @Override
    protected String getIndividualFilesOutputDirectory() {
        return this.individualFilesOutputDirectory;
    }

    @Override
    protected boolean isCsvSummary() {
        return this.csvSummary;
    }

    @Override
    protected String getCsvSummaryFile() {
        return this.csvSummaryFile;
    }

    @Override
    protected boolean isXmlSummary() {
        return this.xmlSummary;
    }

    @Override
    protected String getXmlSummaryFile() {
        return this.xmlSummaryFile;
    }

    @Override
    protected boolean isShasumSummary() {
        return this.shasumSummary;
    }

    @Override
    protected String getShasumSummaryFile() {
        return this.shasumSummaryFile;
    }

    @Override
    protected boolean isFailIfNoFiles() {
        return this.failIfNoFiles;
    }
}

