/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.digest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.digest.AbstractFileDigester;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterException;
import org.bouncycastle.util.encoders.Hex;

public class MessageDigestFileDigester
extends AbstractFileDigester {
    protected MessageDigestFileDigester(String algorithm) throws NoSuchAlgorithmException {
        super(algorithm);
        MessageDigest.getInstance(algorithm);
    }

    @Override
    public String calculate(File file) throws DigesterException {
        String result;
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            byte[] buffer = new byte[32768];
            int size = fis.read(buffer, 0, 32768);
            while (size >= 0) {
                messageDigest.update(buffer, 0, size);
                size = fis.read(buffer, 0, 32768);
            }
            result = new String(Hex.encode((byte[])messageDigest.digest()));
        }
        catch (IOException e) {
            throw new DigesterException("Unable to calculate the " + this.getAlgorithm() + " hashcode for " + file.getPath() + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new DigesterException("Unable not read " + file.getPath() + ": " + e.getMessage());
        }
        return result;
    }
}

