/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.io.Serializable;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.SpotLag;
import net.objectlab.kit.datecalc.common.WorkingWeek;
import net.objectlab.kit.datecalc.common.ccy.CurrencyCalculatorConfig;

public class CurrencyDateCalculatorBuilder<E extends Serializable> {
    private String ccy1;
    private String ccy2;
    private String crossCcy = "USD";
    private HolidayCalendar<E> ccy1Calendar = new DefaultHolidayCalendar();
    private HolidayCalendar<E> ccy2Calendar = new DefaultHolidayCalendar();
    private HolidayCalendar<E> crossCcyCalendar = new DefaultHolidayCalendar();
    private HolidayHandler<E> tenorHolidayHandler;
    private WorkingWeek ccy1Week;
    private WorkingWeek ccy2Week;
    private WorkingWeek crossCcyWeek;
    private CurrencyCalculatorConfig currencyCalculatorConfig;
    private boolean brokenDateAllowed;
    private boolean adjustStartDateWithCurrencyPair = true;
    private SpotLag spotLag = SpotLag.T_2;

    public void checkValidity() {
        StringBuilder b = new StringBuilder();
        if (this.ccy1 == null || this.ccy1.length() == 0) {
            b.append("ccy1 is required");
        }
        if (this.ccy2 == null || this.ccy2.length() == 0) {
            CurrencyDateCalculatorBuilder.append(b, "ccy2 is required");
        }
        if (this.getCcy1Week() == null) {
            CurrencyDateCalculatorBuilder.append(b, "ccy1Week is required");
        }
        if (this.getCcy2Week() == null) {
            CurrencyDateCalculatorBuilder.append(b, "ccy2Week is required");
        }
        if (!this.brokenDateAllowed) {
            this.checkBrokenDate(b);
        }
        if (this.spotLag == null) {
            CurrencyDateCalculatorBuilder.append(b, "spotLag is required");
        }
        if (this.tenorHolidayHandler == null) {
            CurrencyDateCalculatorBuilder.append(b, "tenorHolidayHandler is required");
        }
        if (b.length() > 0) {
            throw new IllegalArgumentException(b.toString());
        }
    }

    private void checkBrokenDate(StringBuilder b) {
        if (this.getCrossCcy() == null) {
            CurrencyDateCalculatorBuilder.append(b, "crossCcy is required");
        }
        if (this.getCrossCcyWeek() == null) {
            CurrencyDateCalculatorBuilder.append(b, "crossCcyWeek is required");
        }
        if (this.getCrossCcyCalendar() == null) {
            CurrencyDateCalculatorBuilder.append(b, "crossCcyCalendar is required");
        }
    }

    private static void append(StringBuilder b, String string) {
        if (b.length() > 0) {
            b.append(",");
        }
        b.append(string);
    }

    public String getCcy1() {
        return this.ccy1;
    }

    public String getCcy2() {
        return this.ccy2;
    }

    public String getCrossCcy() {
        return this.crossCcy;
    }

    public HolidayCalendar<E> getCcy1Calendar() {
        return this.ccy1Calendar;
    }

    public HolidayCalendar<E> getCcy2Calendar() {
        return this.ccy2Calendar;
    }

    public HolidayCalendar<E> getCrossCcyCalendar() {
        return this.crossCcyCalendar;
    }

    public HolidayHandler<E> getTenorHolidayHandler() {
        return this.tenorHolidayHandler;
    }

    public WorkingWeek getCcy1Week() {
        if (this.ccy1Week != null) {
            return this.ccy1Week;
        }
        return this.currencyCalculatorConfig != null ? this.currencyCalculatorConfig.getWorkingWeek(this.ccy1) : null;
    }

    public WorkingWeek getCcy2Week() {
        if (this.ccy2Week != null) {
            return this.ccy2Week;
        }
        return this.currencyCalculatorConfig != null ? this.currencyCalculatorConfig.getWorkingWeek(this.ccy2) : null;
    }

    public WorkingWeek getCrossCcyWeek() {
        if (this.crossCcyWeek != null) {
            return this.crossCcyWeek;
        }
        return this.currencyCalculatorConfig != null ? this.currencyCalculatorConfig.getWorkingWeek(this.crossCcy) : null;
    }

    public CurrencyCalculatorConfig getCurrencyCalculatorConfig() {
        return this.currencyCalculatorConfig;
    }

    public boolean isBrokenDateAllowed() {
        return this.brokenDateAllowed;
    }

    public CurrencyDateCalculatorBuilder<E> currencyPair(String ccy1, String ccy2, SpotLag spotLag) {
        this.ccy1 = ccy1;
        this.ccy2 = ccy2;
        this.spotLag = spotLag;
        return this;
    }

    public SpotLag getSpotLag() {
        return this.spotLag;
    }

    public boolean isAdjustStartDateWithCurrencyPair() {
        return this.adjustStartDateWithCurrencyPair;
    }

    public CurrencyDateCalculatorBuilder<E> adjustStartDateWithCurrencyPair(boolean adjustStartDateWithCurrencyPair) {
        this.adjustStartDateWithCurrencyPair = adjustStartDateWithCurrencyPair;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> brokenDateAllowed(boolean brokenDateAllowed) {
        this.brokenDateAllowed = brokenDateAllowed;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> currencyCalculatorConfig(CurrencyCalculatorConfig currencyCalculatorConfig) {
        this.currencyCalculatorConfig = currencyCalculatorConfig;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> ccy1Calendar(HolidayCalendar<E> ccy1Calendar) {
        if (ccy1Calendar != null) {
            this.ccy1Calendar = ccy1Calendar;
        }
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> ccy2Calendar(HolidayCalendar<E> ccy2Calendar) {
        if (ccy2Calendar != null) {
            this.ccy2Calendar = ccy2Calendar;
        }
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> crossCcy(String crossCcy) {
        this.crossCcy = crossCcy;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> crossCcyCalendar(HolidayCalendar<E> crossCcyCalendar) {
        if (crossCcyCalendar != null) {
            this.crossCcyCalendar = crossCcyCalendar;
        }
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> tenorHolidayHandler(HolidayHandler<E> holidayHandler) {
        this.tenorHolidayHandler = holidayHandler;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> ccy1Week(WorkingWeek ccy1Week) {
        this.ccy1Week = ccy1Week;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> ccy2Week(WorkingWeek ccy2Week) {
        this.ccy2Week = ccy2Week;
        return this;
    }

    public CurrencyDateCalculatorBuilder<E> crossCcyWeek(WorkingWeek crossCcyWeek) {
        this.crossCcyWeek = crossCcyWeek;
        return this;
    }
}

