/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common.ccy;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculator;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.ImmutableHolidayCalendar;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import net.objectlab.kit.datecalc.common.ReadOnlyHolidayCalendar;
import net.objectlab.kit.datecalc.common.SpotLag;
import net.objectlab.kit.datecalc.common.Tenor;
import net.objectlab.kit.datecalc.common.TenorCode;
import net.objectlab.kit.datecalc.common.WorkingWeek;

public abstract class AbstractCurrencyDateCalculator<E extends Serializable>
implements CurrencyDateCalculator<E>,
NonWorkingDayChecker<E> {
    private static final int MONTHS_IN_YEAR = 12;
    private static final int DAYS_IN_WEEK = 7;
    private final String ccy1;
    private final String ccy2;
    private final String crossCcy;
    private final HolidayCalendar<E> ccy1HolidayCalendar;
    private final HolidayCalendar<E> ccy2HolidayCalendar;
    private final HolidayCalendar<E> crossCcyHolidayCalendar;
    private final HolidayHandler<E> holidayHandler;
    private final WorkingWeek ccy1Week;
    private final WorkingWeek ccy2Week;
    private final WorkingWeek crossCcyWeek;
    private final boolean brokenDateAllowed;
    private final boolean useCrossCcyOnT1ForCcy1;
    private final boolean useCrossCcyOnT1ForCcy2;
    private final boolean adjustStartDateWithCcy1Ccy2;
    private final SpotLag spotLag;

    protected AbstractCurrencyDateCalculator(CurrencyDateCalculatorBuilder<E> builder) {
        builder.checkValidity();
        this.ccy1 = builder.getCcy1();
        this.ccy2 = builder.getCcy2();
        this.crossCcy = builder.getCrossCcy();
        this.ccy1HolidayCalendar = new ImmutableHolidayCalendar(builder.getCcy1Calendar() != null ? builder.getCcy1Calendar() : new DefaultHolidayCalendar());
        this.ccy2HolidayCalendar = new ImmutableHolidayCalendar(builder.getCcy2Calendar() != null ? builder.getCcy2Calendar() : new DefaultHolidayCalendar());
        this.crossCcyHolidayCalendar = new ImmutableHolidayCalendar(builder.getCrossCcyCalendar() != null ? builder.getCrossCcyCalendar() : new DefaultHolidayCalendar());
        this.holidayHandler = builder.getTenorHolidayHandler();
        this.ccy1Week = builder.getCcy1Week();
        this.ccy2Week = builder.getCcy2Week();
        this.crossCcyWeek = builder.getCrossCcyWeek();
        this.brokenDateAllowed = builder.isBrokenDateAllowed();
        this.spotLag = builder.getSpotLag();
        this.adjustStartDateWithCcy1Ccy2 = builder.isAdjustStartDateWithCurrencyPair();
        this.useCrossCcyOnT1ForCcy1 = builder.getCurrencyCalculatorConfig() != null && builder.getCurrencyCalculatorConfig().getCurrenciesSubjectToCrossCcyForT1(this.crossCcy).contains(this.ccy1);
        this.useCrossCcyOnT1ForCcy2 = builder.getCurrencyCalculatorConfig() != null && builder.getCurrencyCalculatorConfig().getCurrenciesSubjectToCrossCcyForT1(this.crossCcy).contains(this.ccy2);
    }

    @Override
    public boolean isUseCrossCcyOnT1ForCcy1() {
        return this.useCrossCcyOnT1ForCcy1;
    }

    @Override
    public boolean isUseCrossCcyOnT1ForCcy2() {
        return this.useCrossCcyOnT1ForCcy2;
    }

    @Override
    public SpotLag getSpotLag() {
        return this.spotLag;
    }

    @Override
    public boolean isAdjustStartDateWithCurrencyPair() {
        return this.adjustStartDateWithCcy1Ccy2;
    }

    @Override
    public boolean isBrokenDateAllowed() {
        return this.brokenDateAllowed;
    }

    @Override
    public String getCrossCcy() {
        return this.crossCcy;
    }

    @Override
    public String getCcy1() {
        return this.ccy1;
    }

    @Override
    public String getCcy2() {
        return this.ccy2;
    }

    @Override
    public String getName() {
        return this.getCcy1() + "." + this.getCcy2();
    }

    @Override
    public ReadOnlyHolidayCalendar<E> getCcy1Calendar() {
        return this.ccy1HolidayCalendar;
    }

    @Override
    public ReadOnlyHolidayCalendar<E> getCcy2Calendar() {
        return this.ccy2HolidayCalendar;
    }

    @Override
    public ReadOnlyHolidayCalendar<E> getCrossCcyCalendar() {
        return this.crossCcyHolidayCalendar;
    }

    @Override
    public WorkingWeek getCcy1Week() {
        return this.ccy1Week;
    }

    @Override
    public WorkingWeek getCcy2Week() {
        return this.ccy2Week;
    }

    @Override
    public WorkingWeek getCrossCcyWeek() {
        return this.crossCcyWeek;
    }

    protected abstract E calculateNextDay(E var1);

    protected abstract int calendarWeekDay(E var1);

    protected abstract E max(E var1, E var2);

    private boolean isNonWorkingDay(E date, WorkingWeek ww, HolidayCalendar<E> calendar) {
        return !ww.isWorkingDayFromCalendar(this.calendarWeekDay(date)) || calendar != null && calendar.isHoliday(date);
    }

    @Override
    public boolean isNonWorkingDay(E date) {
        return this.isNonWorkingDay(date, this.ccy1Week, this.ccy1HolidayCalendar) || this.isNonWorkingDay(date, this.ccy2Week, this.ccy2HolidayCalendar) || !this.brokenDateAllowed && this.isNonWorkingDay(date, this.crossCcyWeek, this.crossCcyHolidayCalendar);
    }

    private E adjustToNextWorkingDateForCcyPairIfRequired(E startDate) {
        E date = startDate;
        while (this.isNonWorkingDay(date, this.ccy1Week, this.ccy1HolidayCalendar) || this.isNonWorkingDay(date, this.ccy2Week, this.ccy2HolidayCalendar)) {
            date = this.calculateNextDay(date);
        }
        return date;
    }

    private E adjustToNextWorkingDateForCcyPairAndUsdIfRequired(E startDate) {
        E date = startDate;
        while (this.isNonWorkingDay(date, this.crossCcyWeek, this.crossCcyHolidayCalendar) || this.isNonWorkingDay(date, this.ccy1Week, this.ccy1HolidayCalendar) || this.isNonWorkingDay(date, this.ccy2Week, this.ccy2HolidayCalendar)) {
            date = this.calculateNextDay(date);
        }
        return date;
    }

    private E calculateNextWorkingDay(E startDate, WorkingWeek ww, HolidayCalendar<E> calendar) {
        E date = this.calculateNextDay(startDate);
        while (this.isNonWorkingDay(date, ww, calendar)) {
            date = this.calculateNextDay(date);
        }
        return date;
    }

    private E calculateNextWorkingDayIfRequired(E startDate, WorkingWeek ww, HolidayCalendar<E> calendar) {
        E date = startDate;
        while (this.isNonWorkingDay(date, ww, calendar)) {
            date = this.calculateNextDay(date);
        }
        return date;
    }

    @Override
    public E calculateSpotDate(E startDate) {
        E date = startDate;
        if (this.adjustStartDateWithCcy1Ccy2 || this.spotLag == SpotLag.T_0) {
            date = this.adjustToNextWorkingDateForCcyPairIfRequired(startDate);
        }
        E spotCcy1 = this.calculateCcySpot(this.ccy1, date, this.ccy1Week, this.ccy1HolidayCalendar);
        E spotCcy2 = this.calculateCcySpot(this.ccy2, date, this.ccy2Week, this.ccy2HolidayCalendar);
        E spotDate = this.max(spotCcy1, spotCcy2);
        spotDate = this.brokenDateAllowed ? this.adjustToNextWorkingDateForCcyPairIfRequired(spotDate) : this.adjustToNextWorkingDateForCcyPairAndUsdIfRequired(spotDate);
        return spotDate;
    }

    private E calculateCcySpot(String ccy, E date, WorkingWeek workingWeek, HolidayCalendar<E> calendar) {
        E calcSpot = date;
        if (this.spotLag != SpotLag.T_0) {
            if (this.spotLag == SpotLag.T_2) {
                calcSpot = this.calculateNextWorkingDay(calcSpot, workingWeek, this.crossCcy.equalsIgnoreCase(ccy) ? null : calendar);
                if (this.useCrossCcyOnT1ForCcy1 && this.ccy1.equals(ccy) || this.useCrossCcyOnT1ForCcy2 && this.ccy2.equals(ccy)) {
                    calcSpot = this.calculateNextWorkingDayIfRequired(calcSpot, this.crossCcyWeek, this.crossCcyHolidayCalendar);
                    calcSpot = this.calculateNextWorkingDayIfRequired(calcSpot, workingWeek, calendar);
                }
            }
            calcSpot = this.calculateNextWorkingDay(calcSpot, workingWeek, calendar);
        }
        return calcSpot;
    }

    @Override
    public E calculateTenorDate(E startDate, Tenor tenor) {
        if (tenor == null) {
            throw new IllegalArgumentException("Tenor cannot be null");
        }
        TenorCode tenorCode = tenor.getCode();
        E date = startDate;
        if (tenorCode != TenorCode.OVERNIGHT && tenorCode != TenorCode.TOM_NEXT) {
            date = this.calculateSpotDate(date);
        }
        int unit = tenor.getUnits();
        if (tenorCode == TenorCode.WEEK) {
            tenorCode = TenorCode.DAY;
            unit *= 7;
        }
        if (tenorCode == TenorCode.YEAR) {
            tenorCode = TenorCode.MONTH;
            unit *= 12;
        }
        return this.applyTenor(date, tenorCode, unit);
    }

    private E applyTenor(E date, TenorCode tenorCode, int unit) {
        E calc = date;
        switch (tenorCode) {
            case OVERNIGHT: {
                calc = this.adjustForCcyPairIfRequired(calc);
                break;
            }
            case TOM_NEXT: 
            case SPOT_NEXT: {
                calc = this.calculateNextDay(calc);
                calc = this.adjustForCcyPairIfRequired(calc);
                break;
            }
            case SPOT: {
                break;
            }
            case DAY: {
                for (int i = 0; i < unit; ++i) {
                    calc = this.calculateNextDay(calc);
                }
                calc = this.adjustForCcyPairIfRequired(calc);
                break;
            }
            case MONTH: {
                calc = this.addMonths(calc, unit);
                calc = this.adjustForCcyPairIfRequired(calc);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry not yet...");
            }
        }
        return calc;
    }

    private E adjustForCcyPairIfRequired(E startDate) {
        return (E)((Serializable)this.holidayHandler.adjustDate(startDate, 1, this));
    }

    protected abstract E addMonths(E var1, int var2);

    @Override
    public List<E> calculateTenorDates(E startDate, List<Tenor> tenors) {
        return tenors.stream().map(tenor -> this.calculateTenorDate(startDate, (Tenor)tenor)).collect(Collectors.toList());
    }
}

